"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSchemaForAuthType = exports.AUTH_TYPE_DISCRIMINATOR = void 0;
var _v = require("@kbn/zod/v4");
var _lodash = require("lodash");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AUTH_TYPE_DISCRIMINATOR = exports.AUTH_TYPE_DISCRIMINATOR = 'authType';
const getAuthType = id => {
  for (const s of Object.values(_.authTypeSpecs)) {
    if (s.id === id) {
      return s;
    }
  }
  throw new Error(`Auth type with id ${id} not found.`);
};
const getSchemaForAuthType = authTypeDef => {
  var _authType$schema$meta;
  let authTypeId;
  let defaults;
  let meta;
  if ((0, _lodash.isString)(authTypeDef)) {
    authTypeId = authTypeDef;
  } else {
    var _def$overrides;
    const def = authTypeDef;
    authTypeId = def.type;
    defaults = def.defaults;
    meta = def === null || def === void 0 ? void 0 : (_def$overrides = def.overrides) === null || _def$overrides === void 0 ? void 0 : _def$overrides.meta;
  }
  if (!authTypeId) {
    throw new Error('Auth type ID must be provided.');
  }
  const authType = getAuthType(authTypeId);
  const existingMeta = (_authType$schema$meta = authType.schema.meta()) !== null && _authType$schema$meta !== void 0 ? _authType$schema$meta : {};
  let schemaToUse = _v.z.object({
    ...authType.schema.shape
  });
  if (defaults) {
    Object.keys(defaults).forEach(key => {
      if (schemaToUse.shape[key]) {
        const defaultValue = defaults[key];
        schemaToUse.shape[key] = schemaToUse.shape[key].default(defaultValue);
      }
    });
  }
  if (authType.normalizeSchema) {
    schemaToUse = authType.normalizeSchema(defaults);
  }
  if (meta) {
    Object.keys(meta).forEach(key => {
      if (schemaToUse.shape[key]) {
        const metaValue = schemaToUse.shape[key].meta();
        const metaOverride = meta[key];
        schemaToUse.shape[key] = schemaToUse.shape[key].meta({
          ...metaValue,
          ...metaOverride
        });
      }
    });
  }

  // add the authType discriminator key
  return {
    id: authTypeId,
    schema: schemaToUse.extend({
      [AUTH_TYPE_DISCRIMINATOR]: _v.z.literal(authTypeId)
    }).meta(existingMeta)
  };
};
exports.getSchemaForAuthType = getSchemaForAuthType;