"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.DEFAULT_URL = exports.DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TIMEOUT_MS = exports.DEFAULT_MODEL = exports.DEFAULT_GCP_REGION = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.gemini';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.gemini.title', {
  defaultMessage: 'Google Gemini'
});
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["RUN"] = "run";
  SUB_ACTION["DASHBOARD"] = "getDashboard";
  SUB_ACTION["TEST"] = "test";
  SUB_ACTION["INVOKE_AI"] = "invokeAI";
  SUB_ACTION["INVOKE_AI_RAW"] = "invokeAIRaw";
  SUB_ACTION["INVOKE_STREAM"] = "invokeStream";
  return SUB_ACTION;
}({});
const DEFAULT_TOKEN_LIMIT = exports.DEFAULT_TOKEN_LIMIT = 8192;
const DEFAULT_TIMEOUT_MS = exports.DEFAULT_TIMEOUT_MS = 200000;
const DEFAULT_GCP_REGION = exports.DEFAULT_GCP_REGION = 'us-central1';
const DEFAULT_MODEL = exports.DEFAULT_MODEL = 'gemini-2.5-pro';
const DEFAULT_URL = exports.DEFAULT_URL = `https://us-central1-aiplatform.googleapis.com`;