"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionRuleCounter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _reactRouterDom = require("react-router-dom");
var _useSessionStorage = _interopRequireDefault(require("react-use/lib/useSessionStorage"));
var _reactQuery = require("@kbn/react-query");
var _use_fetch_detection_rules_alerts_status = require("../common/api/use_fetch_detection_rules_alerts_status");
var _use_fetch_detection_rules_by_tags = require("../common/api/use_fetch_detection_rules_by_tags");
var _use_kibana = require("../common/hooks/use_kibana");
var _take_action = require("./take_action");
var _constants = require("../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/detection_rule_counter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RULES_PAGE_PATH = '/rules/management';
const ALERTS_PAGE_PATH = '/alerts';
const RULES_TABLE_SESSION_STORAGE_KEY = 'securitySolution.rulesTable';
const DetectionRuleCounter = ({
  tags,
  createRuleFn
}) => {
  const {
    data: rulesData,
    isLoading: ruleIsLoading
  } = (0, _use_fetch_detection_rules_by_tags.useFetchDetectionRulesByTags)(tags);
  const {
    data: alertsData,
    isLoading: alertsIsLoading,
    isError: alertsIsError
  } = (0, _use_fetch_detection_rules_alerts_status.useFetchDetectionRulesAlertsStatus)(tags);
  const [isCreateRuleLoading, setIsCreateRuleLoading] = (0, _react.useState)(false);
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    http,
    notifications,
    analytics,
    i18n,
    theme
  } = (0, _use_kibana.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const [, setRulesTable] = (0, _useSessionStorage.default)(RULES_TABLE_SESSION_STORAGE_KEY);
  const rulePageNavigation = (0, _react.useCallback)(async () => {
    setRulesTable({
      tags
    });
    history.push({
      pathname: RULES_PAGE_PATH
    });
  }, [history, setRulesTable, tags]);
  const alertsPageNavigation = (0, _react.useCallback)(() => {
    history.push({
      pathname: ALERTS_PAGE_PATH
    });
  }, [history]);
  const createDetectionRuleOnClick = (0, _react.useCallback)(async () => {
    const startServices = {
      analytics,
      notifications,
      i18n,
      theme
    };
    try {
      setIsCreateRuleLoading(true);
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.CREATE_DETECTION_RULE_FROM_FLYOUT);
      const ruleResponse = await createRuleFn(http);
      setIsCreateRuleLoading(false);
      (0, _take_action.showCreateDetectionRuleSuccessToast)(startServices, http, ruleResponse);

      // Triggering a refetch of rules and alerts to update the UI
      queryClient.invalidateQueries([_constants.DETECTION_ENGINE_RULES_KEY]);
      queryClient.invalidateQueries([_constants.DETECTION_ENGINE_ALERTS_KEY]);
    } catch (e) {
      setIsCreateRuleLoading(false);
      (0, _take_action.showCreateDetectionRuleErrorToast)(startServices, e);
    }
  }, [createRuleFn, http, analytics, notifications, i18n, theme, queryClient]);
  if (alertsIsError) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "csp:detection-rule-counter-loading",
    lines: 1,
    size: "m",
    isLoading: ruleIsLoading || alertsIsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, (rulesData === null || rulesData === void 0 ? void 0 : rulesData.total) === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, isCreateRuleLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.creatingRule",
    defaultMessage: "Creating detection rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "csp:findings-flyout-detection-rule-counter-loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: createDetectionRuleOnClick,
    "data-test-subj": "csp:findings-flyout-create-detection-rule-link",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.createRuleAction",
    defaultMessage: "Create a detection rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 19
    }
  })), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.createRuleDescription",
    defaultMessage: "to generate alerts.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: alertsPageNavigation,
    "data-test-subj": "csp:findings-flyout-alert-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.alertCount",
    defaultMessage: "{alertCount, plural, one {# alert} other {# alerts}}",
    values: {
      alertCount: (alertsData === null || alertsData === void 0 ? void 0 : alertsData.total) || 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  })), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.detectedBy",
    defaultMessage: "detected by",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: rulePageNavigation,
    "data-test-subj": "csp:findings-flyout-detection-rule-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findingsFlyout.alerts.detectionRuleCount",
    defaultMessage: "{ruleCount, plural, one {# detection rule} other {# detection rules}}",
    values: {
      ruleCount: (rulesData === null || rulesData === void 0 ? void 0 : rulesData.total) || 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }))));
};
exports.DetectionRuleCounter = DetectionRuleCounter;