"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _control_general_view = require("../control_general_view");
var _control_yaml_view = require("../control_yaml_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_defend/public/components/control_settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VIEW_MODE_GENERAL = 'general';
const VIEW_MODE_YAML = 'yaml';
const ControlSettings = ({
  policy,
  onChange
}) => {
  const [viewMode, setViewMode] = (0, _react.useState)(VIEW_MODE_GENERAL);
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const onViewModeGeneral = (0, _react.useCallback)(() => {
    setViewMode(VIEW_MODE_GENERAL);
  }, []);
  const onViewModeYaml = (0, _react.useCallback)(() => {
    setViewMode(VIEW_MODE_YAML);
  }, []);
  const isGeneralViewSelected = viewMode === VIEW_MODE_GENERAL;
  const isYamlViewSelected = viewMode === VIEW_MODE_YAML;
  const onGeneralChanges = (0, _react.useCallback)(opts => {
    opts.updatedPolicy = policy;
    onChange(opts);
    setIsValid(opts.isValid);
  }, [onChange, policy]);
  const onYamlChanges = (0, _react.useCallback)(opts => {
    opts.updatedPolicy = policy;
    onChange(opts);
    setIsValid(opts.isValid);
  }, [onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    id: VIEW_MODE_GENERAL,
    onClick: onViewModeGeneral,
    isSelected: isGeneralViewSelected,
    "data-test-subj": "cloud-defend-btngeneralview",
    disabled: !isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, i18n.viewModeGeneral), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    id: VIEW_MODE_YAML,
    onClick: onViewModeYaml,
    isSelected: isYamlViewSelected,
    "data-test-subj": "cloud-defend-btnyamlview",
    disabled: !isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, i18n.viewModeYaml))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, isGeneralViewSelected && /*#__PURE__*/_react.default.createElement(_control_general_view.ControlGeneralView, {
    show: isGeneralViewSelected,
    policy: policy,
    onChange: onGeneralChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_control_yaml_view.ControlYamlView, {
    show: isYamlViewSelected,
    policy: policy,
    onChange: onYamlChanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })));
};
exports.ControlSettings = ControlSettings;