"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _service = require("./telemetry/service");
var _api = require("./lib/api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class CloudConnectedPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "telemetry", new _service.CloudConnectTelemetryService());
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    var _plugins$cloud;
    // Skip plugin registration if running on Elastic Cloud.
    // This plugin is only for self-managed clusters connecting to Cloud services
    if ((_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && _plugins$cloud.isCloudEnabled) {
      return {};
    }

    // Setup telemetry
    this.telemetry.setup(core.analytics);

    // Register the app in the management section
    const cloudUrl = this.config.cloudUrl;
    const telemetryService = this.telemetry.getClient();
    core.application.register({
      id: 'cloud_connect',
      title: _i18n.i18n.translate('xpack.cloudConnect.appTitle', {
        defaultMessage: 'Cloud Connect'
      }),
      order: 9035,
      euiIconType: 'logoCloud',
      category: _public.DEFAULT_APP_CATEGORIES.management,
      async mount(params) {
        const [coreStart, depsStart] = await core.getStartServices();
        const apiService = new _api.CloudConnectApiService(coreStart.http);
        const {
          CloudConnectedApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_plugin')));
        return CloudConnectedApp(coreStart, depsStart, params, cloudUrl, telemetryService, apiService);
      }
    });
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.CloudConnectedPlugin = CloudConnectedPlugin;