"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicesSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _details_card = require("./details_card");
var _disable_service_modal = require("./disable_service_modal");
var _use_service_actions = require("./use_service_actions");
var _app_context = require("../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/connected_services/services_section/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ServicesSection = ({
  services,
  onServiceUpdate,
  subscription,
  currentLicenseType
}) => {
  var _services$eis$enabled, _services$eis, _services$eis$support, _services$eis2, _services$eis2$suppor, _services$eis3, _services$eis3$suppor, _services$eis$config$, _services$eis4, _services$eis4$config, _services$eis5, _services$eis5$metada, _services$eis6, _services$eis6$metada, _services$eis7, _services$eis7$suppor, _services$eis8, _services$eis8$subscr, _services$eis9, _services$eis9$suppor, _services$auto_ops$en, _services$auto_ops, _services$auto_ops$su, _services$auto_ops2, _services$auto_ops2$s, _services$auto_ops3, _services$auto_ops3$s, _services$auto_ops$co, _services$auto_ops4, _services$auto_ops4$c, _services$auto_ops5, _services$auto_ops5$m, _services$auto_ops6, _services$auto_ops6$m, _services$auto_ops7, _services$auto_ops7$m, _services$auto_ops8, _services$auto_ops8$s, _services$auto_ops9, _services$auto_ops9$m, _services$auto_ops10, _services$auto_ops10$, _services$auto_ops11, _services$auto_ops11$;
  const {
    autoEnablingEis
  } = (0, _app_context.useCloudConnectedAppContext)();
  const {
    loadingService,
    disableModalService,
    handleEnableService,
    handleDisableService,
    showDisableModal,
    closeDisableModal,
    handleEnableServiceByUrl
  } = (0, _use_service_actions.useServiceActions)({
    onServiceUpdate,
    services
  });

  // Check if there's an active subscription (active or trial)
  const hasActiveSubscription = subscription === 'active' || subscription === 'trial';

  // Build service cards array
  const allServiceCards = [{
    serviceKey: 'eis',
    title: _i18n.i18n.translate('xpack.cloudConnect.services.eis.title', {
      defaultMessage: 'Elastic Inference Service'
    }),
    enabled: (_services$eis$enabled = (_services$eis = services.eis) === null || _services$eis === void 0 ? void 0 : _services$eis.enabled) !== null && _services$eis$enabled !== void 0 ? _services$eis$enabled : false,
    supported: (_services$eis$support = (_services$eis2 = services.eis) === null || _services$eis2 === void 0 ? void 0 : (_services$eis2$suppor = _services$eis2.support) === null || _services$eis2$suppor === void 0 ? void 0 : _services$eis2$suppor.supported) !== null && _services$eis$support !== void 0 ? _services$eis$support : true,
    badgeTooltip: !((_services$eis3 = services.eis) !== null && _services$eis3 !== void 0 && (_services$eis3$suppor = _services$eis3.support) !== null && _services$eis3$suppor !== void 0 && _services$eis3$suppor.supported) ? _i18n.i18n.translate('xpack.cloudConnect.services.unsupportedTooltip', {
      defaultMessage: 'This service is not supported with the current cluster configuration.'
    }) : undefined,
    region: (_services$eis$config$ = (_services$eis4 = services.eis) === null || _services$eis4 === void 0 ? void 0 : (_services$eis4$config = _services$eis4.config) === null || _services$eis4$config === void 0 ? void 0 : _services$eis4$config.region_id) !== null && _services$eis$config$ !== void 0 ? _services$eis$config$ : undefined,
    description: _i18n.i18n.translate('xpack.cloudConnect.services.eis.description', {
      defaultMessage: 'Tap into AI-powered search and chat—no ML model deployment or management needed.'
    }),
    learnMoreUrl: (_services$eis5 = services.eis) === null || _services$eis5 === void 0 ? void 0 : (_services$eis5$metada = _services$eis5.metadata) === null || _services$eis5$metada === void 0 ? void 0 : _services$eis5$metada.documentation_url,
    serviceUrl: (_services$eis6 = services.eis) === null || _services$eis6 === void 0 ? void 0 : (_services$eis6$metada = _services$eis6.metadata) === null || _services$eis6$metada === void 0 ? void 0 : _services$eis6$metada.service_url,
    onEnable: (_services$eis7 = services.eis) !== null && _services$eis7 !== void 0 && (_services$eis7$suppor = _services$eis7.support) !== null && _services$eis7$suppor !== void 0 && _services$eis7$suppor.supported ? () => handleEnableService('eis') : undefined,
    onDisable: () => showDisableModal('eis', _i18n.i18n.translate('xpack.cloudConnect.services.eis.title', {
      defaultMessage: 'Elastic Inference Service'
    })),
    isLoading: loadingService === 'eis' || autoEnablingEis,
    subscriptionRequired: (_services$eis8 = services.eis) === null || _services$eis8 === void 0 ? void 0 : (_services$eis8$subscr = _services$eis8.subscription) === null || _services$eis8$subscr === void 0 ? void 0 : _services$eis8$subscr.required,
    hasActiveSubscription,
    validLicenseTypes: (_services$eis9 = services.eis) === null || _services$eis9 === void 0 ? void 0 : (_services$eis9$suppor = _services$eis9.support) === null || _services$eis9$suppor === void 0 ? void 0 : _services$eis9$suppor.valid_license_types,
    currentLicenseType
  }, {
    serviceKey: 'auto_ops',
    title: _i18n.i18n.translate('xpack.cloudConnect.services.autoOps.title', {
      defaultMessage: 'AutoOps'
    }),
    enabled: (_services$auto_ops$en = (_services$auto_ops = services.auto_ops) === null || _services$auto_ops === void 0 ? void 0 : _services$auto_ops.enabled) !== null && _services$auto_ops$en !== void 0 ? _services$auto_ops$en : false,
    supported: (_services$auto_ops$su = (_services$auto_ops2 = services.auto_ops) === null || _services$auto_ops2 === void 0 ? void 0 : (_services$auto_ops2$s = _services$auto_ops2.support) === null || _services$auto_ops2$s === void 0 ? void 0 : _services$auto_ops2$s.supported) !== null && _services$auto_ops$su !== void 0 ? _services$auto_ops$su : true,
    badgeTooltip: !((_services$auto_ops3 = services.auto_ops) !== null && _services$auto_ops3 !== void 0 && (_services$auto_ops3$s = _services$auto_ops3.support) !== null && _services$auto_ops3$s !== void 0 && _services$auto_ops3$s.supported) ? _i18n.i18n.translate('xpack.cloudConnect.services.unsupportedTooltip', {
      defaultMessage: 'This service is not supported with the current cluster configuration.'
    }) : undefined,
    region: (_services$auto_ops$co = (_services$auto_ops4 = services.auto_ops) === null || _services$auto_ops4 === void 0 ? void 0 : (_services$auto_ops4$c = _services$auto_ops4.config) === null || _services$auto_ops4$c === void 0 ? void 0 : _services$auto_ops4$c.region_id) !== null && _services$auto_ops$co !== void 0 ? _services$auto_ops$co : undefined,
    description: _i18n.i18n.translate('xpack.cloudConnect.services.autoOps.description', {
      defaultMessage: 'Simplify cluster management with real-time issue detection, performance recommendations, and resource utilization insights.'
    }),
    learnMoreUrl: (_services$auto_ops5 = services.auto_ops) === null || _services$auto_ops5 === void 0 ? void 0 : (_services$auto_ops5$m = _services$auto_ops5.metadata) === null || _services$auto_ops5$m === void 0 ? void 0 : _services$auto_ops5$m.documentation_url,
    serviceUrl: (_services$auto_ops6 = services.auto_ops) === null || _services$auto_ops6 === void 0 ? void 0 : (_services$auto_ops6$m = _services$auto_ops6.metadata) === null || _services$auto_ops6$m === void 0 ? void 0 : _services$auto_ops6$m.service_url,
    enableServiceByUrl: (_services$auto_ops7 = services.auto_ops) === null || _services$auto_ops7 === void 0 ? void 0 : (_services$auto_ops7$m = _services$auto_ops7.metadata) === null || _services$auto_ops7$m === void 0 ? void 0 : _services$auto_ops7$m.connect_url,
    onEnable: (_services$auto_ops8 = services.auto_ops) !== null && _services$auto_ops8 !== void 0 && (_services$auto_ops8$s = _services$auto_ops8.support) !== null && _services$auto_ops8$s !== void 0 && _services$auto_ops8$s.supported && (_services$auto_ops9 = services.auto_ops) !== null && _services$auto_ops9 !== void 0 && (_services$auto_ops9$m = _services$auto_ops9.metadata) !== null && _services$auto_ops9$m !== void 0 && _services$auto_ops9$m.connect_url ? () => handleEnableServiceByUrl('auto_ops', services.auto_ops.metadata.connect_url) : undefined,
    onDisable: () => showDisableModal('auto_ops', _i18n.i18n.translate('xpack.cloudConnect.services.autoOps.title', {
      defaultMessage: 'AutoOps'
    })),
    isLoading: loadingService === 'auto_ops',
    subscriptionRequired: (_services$auto_ops10 = services.auto_ops) === null || _services$auto_ops10 === void 0 ? void 0 : (_services$auto_ops10$ = _services$auto_ops10.subscription) === null || _services$auto_ops10$ === void 0 ? void 0 : _services$auto_ops10$.required,
    hasActiveSubscription,
    validLicenseTypes: (_services$auto_ops11 = services.auto_ops) === null || _services$auto_ops11 === void 0 ? void 0 : (_services$auto_ops11$ = _services$auto_ops11.support) === null || _services$auto_ops11$ === void 0 ? void 0 : _services$auto_ops11$.valid_license_types,
    currentLicenseType
  }];

  // Sort service cards: enabled first, then disabled
  const enabledCards = allServiceCards.filter(card => card.enabled);
  const disabledCards = allServiceCards.filter(card => !card.enabled);
  const serviceCards = [...enabledCards, ...disabledCards];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.services.title",
    defaultMessage: "Services",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), serviceCards.map((service, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: service.serviceKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_details_card.ServiceCard, (0, _extends2.default)({}, service, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })), index < serviceCards.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 47
    }
  }))), disableModalService && /*#__PURE__*/_react.default.createElement(_disable_service_modal.DisableServiceModal, {
    serviceName: disableModalService.name,
    onClose: closeDisableModal,
    onConfirm: handleDisableService,
    isLoading: loadingService === disableModalService.key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }));
};
exports.ServicesSection = ServicesSection;