"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCasesSubClient = void 0;
var _bulk_get = require("./bulk_get");
var _create = require("./create");
var _delete = require("./delete");
var _search = require("./search");
var _find = require("./find");
var _get = require("./get");
var _push = require("./push");
var _bulk_update = require("./bulk_update");
var _bulk_create = require("./bulk_create");
var _replace_custom_field = require("./replace_custom_field");
var _similar = require("./similar");
var _observables = require("./observables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * API for interacting with the cases entities.
 */

/**
 * Creates the interface for CRUD on cases objects.
 *
 * @ignore
 */
const createCasesSubClient = (clientArgs, casesClient, casesClientInternal) => {
  const casesSubClient = {
    create: data => (0, _create.create)(data, clientArgs, casesClient),
    bulkCreate: data => (0, _bulk_create.bulkCreate)(data, clientArgs, casesClient),
    find: params => (0, _find.find)(params, clientArgs, casesClient),
    search: params => (0, _search.search)(params, clientArgs, casesClient),
    get: params => (0, _get.get)(params, clientArgs),
    resolve: params => (0, _get.resolve)(params, clientArgs),
    bulkGet: params => (0, _bulk_get.bulkGet)(params, clientArgs),
    push: params => (0, _push.push)(params, clientArgs, casesClient),
    bulkUpdate: cases => (0, _bulk_update.bulkUpdate)(cases, clientArgs, casesClient),
    delete: ids => (0, _delete.deleteCases)(ids, clientArgs),
    getTags: params => (0, _get.getTags)(params, clientArgs),
    getCategories: params => (0, _get.getCategories)(params, clientArgs),
    getReporters: params => (0, _get.getReporters)(params, clientArgs),
    getCasesByAlertID: params => (0, _get.getCasesByAlertID)(params, clientArgs),
    replaceCustomField: params => (0, _replace_custom_field.replaceCustomField)(params, clientArgs, casesClient),
    similar: (caseId, params) => (0, _similar.similar)(caseId, params, clientArgs, casesClient),
    addObservable: (caseId, params) => (0, _observables.addObservable)(caseId, params, clientArgs, casesClient),
    updateObservable: (caseId, observableId, params) => (0, _observables.updateObservable)(caseId, observableId, params, clientArgs, casesClient),
    deleteObservable: (caseId, observableId) => (0, _observables.deleteObservable)(caseId, observableId, clientArgs, casesClient),
    bulkAddObservables: params => (0, _observables.bulkAddObservables)(params, clientArgs, casesClient)
  };
  return Object.freeze(casesSubClient);
};
exports.createCasesSubClient = createCasesSubClient;