"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesFeatures = void 0;
var _react = require("react");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _use_license = require("./use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesFeatures = () => {
  var _features$observables, _features$observables2;
  const {
    features,
    permissions: {
      assign
    }
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isAtLeastGold,
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  const hasLicenseGreaterThanPlatinum = isAtLeastPlatinum();
  const hasLicenseWithAtLeastGold = isAtLeastGold();
  const casesFeatures = (0, _react.useMemo)(() => ({
    isAlertsEnabled: features.alerts.enabled,
    /**
     * If the alerts feature is disabled we will disable everything.
     * If not, then we honor the sync option.
     * The sync and enabled option in DEFAULT_FEATURES in x-pack/plugins/cases/common/constants.ts
     * is defaulted to true. This will help consumers to set the enabled
     * option to true and get the whole alerts experience without the need
     * to explicitly set the sync to true
     */
    isSyncAlertsEnabled: !features.alerts.enabled || !features.alerts.all ? false : features.alerts.sync,
    metricsFeatures: features.metrics,
    caseAssignmentAuthorized: hasLicenseGreaterThanPlatinum && assign,
    pushToServiceAuthorized: hasLicenseGreaterThanPlatinum,
    observablesAuthorized: hasLicenseGreaterThanPlatinum,
    connectorsAuthorized: hasLicenseWithAtLeastGold,
    isObservablesFeatureEnabled: !!features.observables.enabled,
    isExtractObservablesEnabled: !!features.observables.enabled && !!features.observables.autoExtract
  }), [features.alerts.enabled, features.alerts.sync, features.alerts.all, features.metrics, hasLicenseGreaterThanPlatinum, assign, (_features$observables = features.observables) === null || _features$observables === void 0 ? void 0 : _features$observables.enabled, (_features$observables2 = features.observables) === null || _features$observables2 === void 0 ? void 0 : _features$observables2.autoExtract, hasLicenseWithAtLeastGold]);
  return casesFeatures;
};
exports.useCasesFeatures = useCasesFeatures;