"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertUserActionsToCamelCase = exports.convertToCamelCase = exports.convertSimilarCasesToCamelCase = exports.convertSimilarCasesToCamel = exports.convertSimilarCaseToCamelCase = exports.convertCasesToCamelCase = exports.convertCaseToCamelCase = exports.convertCaseResolveToCamelCase = exports.convertAttachmentsToCamelCase = exports.convertAttachmentToCamelCase = exports.convertArrayToCamelCase = exports.convertAllCasesToCamel = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _attachments = require("../../common/utils/attachments");
var _user_actions = require("../../common/utils/user_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertArrayToCamelCase = arrayOfSnakes => arrayOfSnakes.reduce((acc, value) => {
  if ((0, _lodash.isArray)(value)) {
    acc.push(convertArrayToCamelCase(value));
  } else if ((0, _lodash.isObject)(value)) {
    acc.push(convertToCamelCase(value));
  } else {
    acc.push(value);
  }
  return acc;
}, []);
exports.convertArrayToCamelCase = convertArrayToCamelCase;
const convertToCamelCase = obj => Object.entries(obj).reduce((acc, [key, value]) => {
  if ((0, _lodash.isArray)(value)) {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), convertArrayToCamelCase(value));
  } else if ((0, _lodash.isObject)(value)) {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), convertToCamelCase(value));
  } else {
    (0, _saferLodashSet.set)(acc, (0, _lodash.camelCase)(key), value);
  }
  return acc;
}, {});
exports.convertToCamelCase = convertToCamelCase;
const convertCaseToCamelCase = theCase => {
  const {
    comments,
    ...restCase
  } = theCase;
  return {
    ...convertToCamelCase(restCase),
    ...(comments != null ? {
      comments: convertAttachmentsToCamelCase(comments)
    } : {})
  };
};
exports.convertCaseToCamelCase = convertCaseToCamelCase;
const convertCasesToCamelCase = cases => cases.map(convertCaseToCamelCase);
exports.convertCasesToCamelCase = convertCasesToCamelCase;
const convertSimilarCaseToCamelCase = theCase => {
  const {
    comments,
    ...restCase
  } = theCase;
  return {
    ...convertToCamelCase(restCase)
  };
};
exports.convertSimilarCaseToCamelCase = convertSimilarCaseToCamelCase;
const convertSimilarCasesToCamelCase = cases => cases.map(convertSimilarCaseToCamelCase);
exports.convertSimilarCasesToCamelCase = convertSimilarCasesToCamelCase;
const convertCaseResolveToCamelCase = res => {
  const {
    case: theCase,
    ...rest
  } = res;
  return {
    ...convertToCamelCase(rest),
    case: convertCaseToCamelCase(theCase)
  };
};
exports.convertCaseResolveToCamelCase = convertCaseResolveToCamelCase;
const convertAttachmentsToCamelCase = attachments => {
  return attachments.map(attachment => convertAttachmentToCamelCase(attachment));
};
exports.convertAttachmentsToCamelCase = convertAttachmentsToCamelCase;
const convertAttachmentToCamelCase = attachment => {
  if ((0, _attachments.isCommentRequestTypeExternalReference)(attachment)) {
    return convertAttachmentToCamelExceptProperty(attachment, 'externalReferenceMetadata');
  }
  if ((0, _attachments.isCommentRequestTypePersistableState)(attachment)) {
    return convertAttachmentToCamelExceptProperty(attachment, 'persistableStateAttachmentState');
  }
  return convertToCamelCase(attachment);
};
exports.convertAttachmentToCamelCase = convertAttachmentToCamelCase;
const convertUserActionsToCamelCase = userActions => {
  return userActions.map(userAction => {
    if ((0, _user_actions.isCommentUserAction)(userAction)) {
      const userActionWithoutPayload = (0, _lodash.omit)(userAction, 'payload.comment');
      const camelCaseUserActionWithoutPayload = convertToCamelCase(userActionWithoutPayload);
      return {
        ...camelCaseUserActionWithoutPayload,
        payload: {
          comment: convertAttachmentToCamelCase(userAction.payload.comment)
        }
      };
    }
    return convertToCamelCase(userAction);
  });
};
exports.convertUserActionsToCamelCase = convertUserActionsToCamelCase;
const convertAttachmentToCamelExceptProperty = (attachment, key) => {
  const intactValue = (0, _lodash.get)(attachment, key);
  const attachmentWithoutIntactValue = (0, _lodash.omit)(attachment, key);
  const camelCaseAttachmentWithoutIntactValue = convertToCamelCase(attachmentWithoutIntactValue);
  return {
    ...camelCaseAttachmentWithoutIntactValue,
    [key]: intactValue
  };
};
const convertAllCasesToCamel = snakeCases => ({
  cases: convertCasesToCamelCase(snakeCases.cases),
  countOpenCases: snakeCases.count_open_cases,
  countInProgressCases: snakeCases.count_in_progress_cases,
  countClosedCases: snakeCases.count_closed_cases,
  page: snakeCases.page,
  perPage: snakeCases.per_page,
  total: snakeCases.total
});
exports.convertAllCasesToCamel = convertAllCasesToCamel;
const convertSimilarCasesToCamel = snakeCases => ({
  cases: convertSimilarCasesToCamelCase(snakeCases.cases),
  page: snakeCases.page,
  perPage: snakeCases.per_page,
  total: snakeCases.total
});
exports.convertSimilarCasesToCamel = convertSimilarCasesToCamel;