"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integrationSavedObjectType = void 0;
var _integration_schema = require("./schemas/integration_schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationSavedObjectType = exports.integrationSavedObjectType = {
  name: _constants.INTEGRATION_SAVED_OBJECT_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      integration_id: {
        type: 'keyword'
      },
      data_stream_count: {
        type: 'integer'
      },
      created_by: {
        type: 'keyword'
      },
      status: {
        type: 'keyword'
      },
      metadata: {
        properties: {
          // version , description , created_at etc.,
        }
      }
    }
  },
  management: {
    icon: 'integration',
    defaultSearchField: 'integration_id',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.integration_id;
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: _integration_schema.integrationSchemaV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: _integration_schema.integrationSchemaV1
      }
    }
  }
};