"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAuthenticatedUser = getAuthenticatedUser;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAuthenticatedUser(request, security) {
  if (!security) {
    throw new Error('Security service not initialized');
  }
  try {
    const user = security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('Current authenticated user not found');
    }
    return user;
  } catch (error) {
    throw new Error(`Failed to get authenticated user: ${error.message}`);
  }
}