"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomaticImportV2Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _rxjs = require("rxjs");
var _request_context_factory = require("./request_context_factory");
var _services = require("./services");
var _feature = require("./feature");
var _register_routes = require("./routes/register_routes");
var _constants = require("./services/saved_objects/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutomaticImportV2Plugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "automaticImportService", null);
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
    this.logger = initializerContext.logger.get();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
  }

  /**
   * Setup the plugin
   * @param core
   * @param plugins
   * @returns AutomaticImportPluginSetup
   */
  setup(core, plugins) {
    this.logger.debug('automaticImportV2: Setup');
    plugins.features.registerKibanaFeature(_feature.AUTOMATIC_IMPORT_FEATURE);
    this.automaticImportService = new _services.AutomaticImportService(this.logger, core.savedObjects, plugins.taskManager);
    const requestContextFactory = new _request_context_factory.RequestContextFactory({
      logger: this.logger,
      core,
      plugins,
      kibanaVersion: this.kibanaVersion,
      automaticImportService: this.automaticImportService
    });
    core.http.registerRouteHandlerContext('automaticImportv2', (context, request) => requestContextFactory.create(context, request));
    const router = core.http.createRouter();
    (0, _register_routes.registerRoutes)(router, this.logger);
    return {
      actions: plugins.actions
    };
  }

  /**
   * Start the plugin
   * @param core
   * @param plugins
   * @returns AutomaticImportPluginStart
   */
  start(core, plugins) {
    this.logger.debug('automaticImportV2: Started');
    if (!this.automaticImportService) {
      throw new Error('AutomaticImportService not initialized during setup');
    }
    const savedObjectsClient = core.savedObjects.createInternalRepository([_constants.INTEGRATION_SAVED_OBJECT_TYPE, _constants.DATA_STREAM_SAVED_OBJECT_TYPE]);
    this.automaticImportService.initialize(new _server.SavedObjectsClient(savedObjectsClient), plugins.taskManager).then(() => {
      this.logger.debug('AutomaticImportService initialized successfully');
    }).catch(error => {
      this.logger.error('Failed to initialize AutomaticImportService', error);
    });
    return {};
  }

  /**
   * Stop the plugin
   */
  stop() {
    var _this$automaticImport;
    this.pluginStop$.next();
    this.pluginStop$.complete();
    (_this$automaticImport = this.automaticImportService) === null || _this$automaticImport === void 0 ? void 0 : _this$automaticImport.stop();
  }
}
exports.AutomaticImportV2Plugin = AutomaticImportV2Plugin;