"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelInput = modelInput;
exports.modelMergedInputFromSubGraph = modelMergedInputFromSubGraph;
exports.modelOutput = modelOutput;
exports.modelSubOutput = modelSubOutput;
var _samples = require("../../util/samples");
var _chunk = require("./chunk");
var _constants = require("./constants");
var _pipeline = require("./pipeline");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function modelSubOutput({
  state
}) {
  return {
    lastExecutedChain: 'modelSubOutput',
    chunkMapping: state.currentMapping
  };
}
function modelMergedInputFromSubGraph({
  state
}) {
  return {
    lastExecutedChain: 'modelMergedInputFromSubGraph',
    useFinalMapping: true,
    finalMapping: state.chunkMapping
  };
}
function modelInput({
  state
}) {
  const prefixedSamples = (0, _samples.prefixSamples)(state);
  const sampleChunks = (0, _chunk.mergeAndChunkSamples)(prefixedSamples, state.chunkSize);
  return {
    exAnswer: JSON.stringify(_constants.ECS_EXAMPLE_ANSWER, null, 2),
    ecs: JSON.stringify((0, _validate.removeReservedFields)(_constants.ECS_FIELDS), null, 2),
    prefixedSamples,
    sampleChunks,
    finalized: false,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput({
  state
}) {
  const currentPipeline = (0, _pipeline.createPipeline)(state);
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      mapping: state.finalMapping,
      pipeline: currentPipeline
    }
  };
}