"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNodes = getServiceNodes;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
var _service_nodes = require("../../../common/service_nodes");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _environment_query = require("../../../common/utils/environment_query");
var _has_otel_metrics = require("./has_otel_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceNodes({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end
}) {
  const useOTelMetrics = await (0, _has_otel_metrics.hasOTelMetrics)({
    kuery,
    apmEventClient,
    serviceName,
    environment,
    start,
    end
  });
  const serviceNodeFunc = useOTelMetrics ? getOTelServiceNodes : getElasticServiceNodes;
  return serviceNodeFunc({
    kuery,
    apmEventClient,
    serviceName,
    environment,
    start,
    end
  });
}
async function getElasticServiceNodes({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end
}) {
  const params = {
    apm: {
      events: [_common.ProcessorEvent.metric]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [{
          term: {
            [_apm.SERVICE_NAME]: serviceName
          }
        }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
      }
    },
    aggs: {
      nodes: {
        terms: {
          field: _apm.SERVICE_NODE_NAME,
          size: 10000,
          missing: _service_nodes.SERVICE_NODE_NAME_MISSING
        },
        aggs: {
          latest: {
            top_metrics: {
              metrics: (0, _as_mutable_array.asMutableArray)([{
                field: _apm.HOST_NAME
              }]),
              sort: {
                '@timestamp': 'desc'
              }
            }
          },
          cpu: {
            avg: {
              field: _apm.METRIC_PROCESS_CPU_PERCENT
            }
          },
          heapMemory: {
            avg: {
              field: _apm.METRIC_JAVA_HEAP_MEMORY_USED
            }
          },
          nonHeapMemory: {
            avg: {
              field: _apm.METRIC_JAVA_NON_HEAP_MEMORY_USED
            }
          },
          threadCount: {
            max: {
              field: _apm.METRIC_JAVA_THREAD_COUNT
            }
          }
        }
      }
    }
  };
  const response = await apmEventClient.search('get_service_nodes', params);
  if (!response.aggregations) {
    return [];
  }
  return response.aggregations.nodes.buckets.map(bucket => {
    var _bucket$latest$top, _bucket$latest$top$, _bucket$latest$top$$m;
    return {
      name: bucket.key,
      cpu: bucket.cpu.value,
      heapMemory: bucket.heapMemory.value,
      hostName: (_bucket$latest$top = bucket.latest.top) === null || _bucket$latest$top === void 0 ? void 0 : (_bucket$latest$top$ = _bucket$latest$top[0]) === null || _bucket$latest$top$ === void 0 ? void 0 : (_bucket$latest$top$$m = _bucket$latest$top$.metrics) === null || _bucket$latest$top$$m === void 0 ? void 0 : _bucket$latest$top$$m[_apm.HOST_NAME],
      nonHeapMemory: bucket.nonHeapMemory.value,
      threadCount: bucket.threadCount.value
    };
  }).filter(item => item.cpu !== null || item.heapMemory !== null || item.nonHeapMemory !== null || item.threadCount != null);
}
async function getOTelServiceNodes({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end
}) {
  const params = {
    apm: {
      events: [_common.ProcessorEvent.metric]
    },
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [{
          term: {
            [_apm.SERVICE_NAME]: serviceName
          }
        }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
      }
    },
    aggs: {
      nodes: {
        terms: {
          field: _apm.SERVICE_NODE_NAME,
          size: 10000,
          missing: _service_nodes.SERVICE_NODE_NAME_MISSING
        },
        aggs: {
          latest: {
            top_metrics: {
              metrics: (0, _as_mutable_array.asMutableArray)([{
                field: _apm.HOST_NAME
              }]),
              sort: {
                '@timestamp': 'desc'
              }
            }
          },
          cpu: {
            avg: {
              field: _apm.METRIC_OTEL_JVM_PROCESS_CPU_PERCENT
            }
          },
          heapMemory: {
            filter: {
              term: {
                [_apm.LABEL_TYPE]: _apm.VALUE_OTEL_JVM_PROCESS_MEMORY_HEAP
              }
            },
            aggs: {
              usage: {
                avg: {
                  field: _apm.METRIC_OTEL_JVM_PROCESS_MEMORY_USAGE
                }
              }
            }
          },
          nonHeapMemory: {
            filter: {
              term: {
                [_apm.LABEL_TYPE]: _apm.VALUE_OTEL_JVM_PROCESS_MEMORY_NON_HEAP
              }
            },
            aggs: {
              usage: {
                avg: {
                  field: _apm.METRIC_OTEL_JVM_PROCESS_MEMORY_USAGE
                }
              }
            }
          },
          threadCount: {
            max: {
              field: _apm.METRIC_OTEL_JVM_PROCESS_THREADS_COUNT
            }
          }
        }
      }
    }
  };
  const response = await apmEventClient.search('get_otel_service_nodes', params);
  if (!response.aggregations) {
    return [];
  }
  return response.aggregations.nodes.buckets.map(bucket => {
    var _bucket$latest$top2, _bucket$latest$top2$, _bucket$latest$top2$$;
    return {
      name: bucket.key,
      cpu: bucket.cpu.value,
      heapMemory: bucket.heapMemory.usage.value,
      hostName: (_bucket$latest$top2 = bucket.latest.top) === null || _bucket$latest$top2 === void 0 ? void 0 : (_bucket$latest$top2$ = _bucket$latest$top2[0]) === null || _bucket$latest$top2$ === void 0 ? void 0 : (_bucket$latest$top2$$ = _bucket$latest$top2$.metrics) === null || _bucket$latest$top2$$ === void 0 ? void 0 : _bucket$latest$top2$$[_apm.HOST_NAME],
      nonHeapMemory: bucket.nonHeapMemory.usage.value,
      threadCount: bucket.threadCount.value
    };
  }).filter(item => item.cpu !== null || item.heapMemory !== null || item.nonHeapMemory !== null || item.threadCount != null);
}