"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceWaterfallContext = void 0;
exports.TraceWaterfallContextProvider = TraceWaterfallContextProvider;
exports.groupByParent = groupByParent;
exports.useTraceWaterfallContext = useTraceWaterfallContext;
var _react = _interopRequireWildcard(require("react"));
var _legend = require("../../../../common/waterfall/legend");
var _toggle_accordion_button = require("./toggle_accordion_button");
var _trace_item_row = require("./trace_item_row");
var _use_trace_waterfall = require("./use_trace_waterfall");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/trace_waterfall_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TraceWaterfallContext = exports.TraceWaterfallContext = /*#__PURE__*/(0, _react.createContext)({
  duration: 0,
  traceState: _use_trace_waterfall.TraceDataState.Empty,
  traceWaterfall: [],
  rootItem: undefined,
  margin: {
    left: 0,
    right: 0
  },
  traceWaterfallMap: {},
  showAccordion: true,
  isAccordionOpen: true,
  accordionStatesMap: {},
  toggleAccordionState: () => {},
  toggleAllAccordions: () => {},
  isEmbeddable: false,
  legends: [],
  colorBy: _legend.WaterfallLegendType.ServiceName,
  showLegend: false,
  serviceName: '',
  errorMarks: []
});
function TraceWaterfallContextProvider({
  children,
  traceItems,
  showAccordion,
  highlightedTraceId,
  onClick,
  onErrorClick,
  scrollElement,
  getRelatedErrorsHref,
  isEmbeddable,
  showLegend,
  serviceName,
  isFiltered,
  errors
}) {
  const {
    duration,
    traceWaterfall,
    maxDepth,
    rootItem,
    legends,
    colorBy,
    traceState,
    message,
    errorMarks
  } = (0, _use_trace_waterfall.useTraceWaterfall)({
    traceItems,
    isFiltered,
    errors,
    onErrorClick
  });
  const [isAccordionOpen, setAccordionOpen] = (0, _react.useState)(true);
  const [accordionStatesMap, setAccordionStateMap] = (0, _react.useState)(() => traceWaterfall.reduce((acc, item) => {
    acc[item.id] = 'open';
    return acc;
  }, {}));
  const toggleAccordionState = (0, _react.useCallback)(id => {
    setAccordionStateMap(prevStates => ({
      ...prevStates,
      [id]: prevStates[id] === 'open' ? 'closed' : 'open'
    }));
  }, []);
  const toggleAllAccordions = (0, _react.useCallback)(() => {
    setAccordionStateMap(prevAccordionStates => Object.keys(prevAccordionStates).reduce((acc, id) => {
      acc[id] = isAccordionOpen ? 'closed' : 'open';
      return acc;
    }, {}));
    setAccordionOpen(prev => !prev);
  }, [isAccordionOpen]);
  const left = _toggle_accordion_button.TOGGLE_BUTTON_WIDTH + _trace_item_row.ACCORDION_PADDING_LEFT * maxDepth;
  const right = 40;
  const traceWaterfallMap = (0, _react.useMemo)(() => groupByParent(traceWaterfall), [traceWaterfall]);
  return /*#__PURE__*/_react.default.createElement(TraceWaterfallContext.Provider, {
    value: {
      traceState,
      duration,
      rootItem,
      traceWaterfall,
      margin: {
        left: showAccordion ? Math.max(100, left) : left,
        right
      },
      traceWaterfallMap,
      showAccordion,
      isAccordionOpen,
      accordionStatesMap,
      toggleAccordionState,
      toggleAllAccordions,
      onClick,
      onErrorClick,
      highlightedTraceId,
      scrollElement,
      getRelatedErrorsHref,
      isEmbeddable,
      legends,
      colorBy,
      showLegend,
      serviceName,
      message,
      errorMarks
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, children);
}
function useTraceWaterfallContext() {
  const context = (0, _react.useContext)(TraceWaterfallContext);
  if (!context) {
    throw new Error('useTraceWaterfallContext must be used within a TraceWaterfallContextProvider');
  }
  return context;
}
function groupByParent(items) {
  return items.reduce((acc, item) => {
    if (item.parentId) {
      if (!acc[item.parentId]) acc[item.parentId] = [];
      acc[item.parentId].push(item);
    }
    return acc;
  }, {});
}