"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarDetails = BarDetails;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _formatters = require("../../../../common/utils/formatters");
var _truncate_with_tooltip = require("../truncate_with_tooltip");
var _trace_waterfall_context = require("./trace_waterfall_context");
var _is_failure_or_error = require("./utils/is_failure_or_error");
var _span_links_badge = require("./badges/span_links_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/bar_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ORPHAN_TITLE = _i18n.i18n.translate('xpack.apm.trace.barDetails.euiIconTip.orphanTitleLabel', {
  defaultMessage: 'Orphan'
});
const ORPHAN_CONTENT = _i18n.i18n.translate('xpack.apm.trace.barDetails.euiIconTip.orphanSpanContentLabel', {
  defaultMessage: 'This span is orphaned due to missing trace context and has been reparented to the root to restore the execution flow'
});
function BarDetails({
  item,
  left
}) {
  var _item$status;
  const theme = (0, _eui.useEuiTheme)();
  const {
    getRelatedErrorsHref,
    onErrorClick
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  const itemStatusIsFailureOrError = (0, _is_failure_or_error.isFailureOrError)((_item$status = item.status) === null || _item$status === void 0 ? void 0 : _item$status.value);
  const errorCount = item.errors.length;
  const viewRelatedErrorsLabel = _i18n.i18n.translate('xpack.apm.waterfall.embeddableRelatedErrors.unifedErrorCount', {
    defaultMessage: '{count, plural, one {View error} other {View # errors}}',
    values: {
      count: errorCount
    }
  });
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        position: relative;
        height: ${theme.euiTheme.size.l};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    css: (0, _react.css)`
          min-width: ${Math.max(100 - left, 0)}%;
          position: absolute;
          right: 0;
          max-width: 100%;
          margin-top: ${theme.euiTheme.size.xxs};
          & > div:last-child {
            margin-right: ${theme.euiTheme.size.s};
            white-space: nowrap;
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
            min-width: 0;
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: {
      overflow: 'hidden'
    },
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
    content: item.name,
    text: item.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, (0, _formatters.asDuration)(item.duration))), item.status && itemStatusIsFailureOrError && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "apmBarDetailsFailureTooltip",
    content: `${item.status.fieldName} = ${item.status.value}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "apmBarDetailsFailureBadge",
    color: "danger",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }, item.status.value))), errorCount > 0 ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, getRelatedErrorsHref || onErrorClick ?
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react2.default.createElement(_eui.EuiBadge, {
    color: theme.euiTheme.colors.danger,
    iconType: "arrowRight",
    href: getRelatedErrorsHref === null || getRelatedErrorsHref === void 0 ? void 0 : getRelatedErrorsHref(item.id),
    onClick: e => {
      if (onErrorClick) {
        e.preventDefault();
        e.stopPropagation();
        onErrorClick({
          traceId: item.traceId,
          docId: item.id,
          errorCount,
          errorDocId: errorCount > 1 ? undefined : item.errors[0].errorDocId
        });
      }
    },
    tabIndex: 0,
    role: "button",
    "aria-label": viewRelatedErrorsLabel,
    onClickAriaLabel: viewRelatedErrorsLabel,
    "data-test-subj": "apmBarDetailsErrorBadge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, viewRelatedErrorsLabel) : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "errorFilled",
    color: theme.euiTheme.colors.danger,
    size: "s",
    "data-test-subj": "apmBarDetailsErrorIcon",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  })) : null, item.isOrphan ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    "data-test-subj": "apmBarDetailsOrphanTooltip",
    iconProps: {
      'data-test-subj': 'apmBarDetailsOrphanIcon',
      'aria-label': ORPHAN_TITLE
    },
    color: theme.euiTheme.colors.danger,
    type: "unlink",
    title: ORPHAN_TITLE,
    content: ORPHAN_CONTENT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react2.default.createElement(_span_links_badge.SpanLinksBadge, {
    outgoingCount: item.spanLinksCount.outgoing,
    incomingCount: item.spanLinksCount.incoming,
    id: item.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  })));
}