"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTransactionDistributionChartData = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/correlations/constants");
var _apm = require("../../../../../common/es_fields/apm");
var _event_outcome = require("../../../../../common/event_outcome");
var _latency_distribution_chart_types = require("../../../../../common/latency_distribution_chart_types");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _is_error_message = require("../../correlations/utils/is_error_message");
var _use_fetch_params = require("../../correlations/use_fetch_params");
var _get_transaction_distribution_chart_data = require("../../correlations/get_transaction_distribution_chart_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTransactionDistributionChartData = () => {
  const params = (0, _use_fetch_params.useFetchParams)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    data: overallLatencyData = {},
    status: overallLatencyStatus,
    error: overallLatencyError
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (params.serviceName && params.environment && params.start && params.end) {
      return callApmApi('POST /internal/apm/latency/overall_distribution/transactions', {
        params: {
          body: {
            ...params,
            percentileThreshold: _constants.DEFAULT_PERCENTILE_THRESHOLD,
            chartType: _latency_distribution_chart_types.LatencyDistributionChartType.transactionLatency
          }
        }
      });
    }
  }, [params]);
  (0, _react.useEffect)(() => {
    if ((0, _is_error_message.isErrorMessage)(overallLatencyError)) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.transactionDetails.distribution.latencyDistributionErrorTitle', {
          defaultMessage: 'An error occurred fetching the overall latency distribution.'
        }),
        text: overallLatencyError.toString()
      });
    }
  }, [overallLatencyError, notifications.toasts]);
  const overallLatencyHistogram = overallLatencyData.overallHistogram === undefined && overallLatencyStatus !== _use_fetcher.FETCH_STATUS.LOADING ? [] : overallLatencyData.overallHistogram;
  const hasData = Array.isArray(overallLatencyHistogram) && overallLatencyHistogram.length > 0;
  const {
    data: errorHistogramData = {},
    error: errorHistogramError
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (params.serviceName && params.environment && params.start && params.end && overallLatencyData.durationMin && overallLatencyData.durationMax) {
      return callApmApi('POST /internal/apm/latency/overall_distribution/transactions', {
        params: {
          body: {
            ...params,
            durationMin: overallLatencyData.durationMin,
            durationMax: overallLatencyData.durationMax,
            percentileThreshold: _constants.DEFAULT_PERCENTILE_THRESHOLD,
            termFilters: [{
              fieldName: _apm.EVENT_OUTCOME,
              fieldValue: _event_outcome.EventOutcome.failure
            }],
            chartType: _latency_distribution_chart_types.LatencyDistributionChartType.transactionLatency
          }
        }
      });
    }
  }, [params, overallLatencyData.durationMin, overallLatencyData.durationMax]);
  (0, _react.useEffect)(() => {
    if ((0, _is_error_message.isErrorMessage)(errorHistogramError)) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.transactionDetails.distribution.failedTransactionsLatencyDistributionErrorTitle', {
          defaultMessage: 'An error occurred fetching the failed transactions latency distribution.'
        }),
        text: errorHistogramError.toString()
      });
    }
  }, [errorHistogramError, notifications.toasts]);
  const transactionDistributionChartData = (0, _get_transaction_distribution_chart_data.getTransactionDistributionChartData)({
    euiTheme,
    allTransactionsHistogram: overallLatencyHistogram,
    failedTransactionsHistogram: errorHistogramData.overallHistogram
  });
  return {
    totalDocCount: overallLatencyData.totalDocCount,
    chartData: transactionDistributionChartData,
    hasData,
    percentileThresholdValue: overallLatencyData.percentileThresholdValue,
    status: overallLatencyStatus
  };
};
exports.useTransactionDistributionChartData = useTransactionDistributionChartData;