"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDistribution = TransactionDistribution;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/observability-plugin/common");
var _apmTypes = require("@kbn/apm-types");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_waterfall_fetcher = require("../use_waterfall_fetcher");
var _waterfall_with_summary = require("../waterfall_with_summary");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _duration_distribution_chart_with_scrubber = require("../../../shared/charts/duration_distribution_chart_with_scrubber");
var _resetting_height_container = require("../../../shared/height_retainer/resetting_height_container");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_transaction_distribution_chart_data = require("./use_transaction_distribution_chart_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/distribution/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TransactionDistribution({
  onChartSelection,
  onClearSelection,
  selection,
  traceSamplesFetchResult
}) {
  var _waterfallFetchResult, _traceSamplesFetchRes;
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    traceId,
    transactionId
  } = urlParams;
  const {
    query: {
      rangeFrom,
      rangeTo,
      showCriticalPath,
      environment
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const history = (0, _reactRouterDom.useHistory)();
  const waterfallFetchResult = (0, _use_waterfall_fetcher.useWaterfallFetcher)({
    traceId,
    transactionId,
    start,
    end
  });
  const {
    waterfallItemId,
    detailTab
  } = urlParams;
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const markerCurrentEvent = (_waterfallFetchResult = waterfallFetchResult.waterfall.entryWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.doc.transaction.duration.us;
  const {
    chartData,
    hasData,
    percentileThresholdValue,
    status,
    totalDocCount
  } = (0, _use_transaction_distribution_chart_data.useTransactionDistributionChartData)();
  const onShowCriticalPathChange = (0, _react.useCallback)(nextShowCriticalPath => {
    (0, _url_helpers.push)(history, {
      query: {
        showCriticalPath: nextShowCriticalPath ? 'true' : 'false'
      }
    });
  }, [history]);
  const onTabClick = (0, _react.useCallback)(tab => {
    history.replace({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        detailTab: tab
      })
    });
  }, [history]);
  const onSampleClick = (0, _react.useCallback)(sample => {
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        transactionId: sample.transactionId,
        traceId: sample.traceId
      })
    });
  }, [history]);

  // Parse logs state from URL params
  const {
    logsColumns,
    logsSort,
    logsGrid,
    logsRowHeight,
    logsRowsPerPage,
    logsDensity
  } = urlParams;
  const logsTableConfig = (0, _react.useMemo)(() => ({
    columns: logsColumns ? JSON.parse(logsColumns) : undefined,
    sort: logsSort ? JSON.parse(logsSort) : undefined,
    grid: logsGrid ? JSON.parse(logsGrid) : undefined,
    rowHeight: logsRowHeight,
    rowsPerPage: logsRowsPerPage,
    density: logsDensity
  }), [logsColumns, logsSort, logsGrid, logsRowHeight, logsRowsPerPage, logsDensity]);

  // Handle logs table config changes and sync to URL
  const onLogsTableConfigChange = (0, _react.useCallback)(config => {
    var _config$sort, _config$grid;
    const currentQuery = (0, _url_helpers.toQuery)(history.location.search);
    const isFieldIncludedInColumns = fieldName => fieldName === _apmTypes.AT_TIMESTAMP || config.columns && config.columns.includes(fieldName);

    // Clean up sort configuration to only include columns that exist
    const cleanedSort = (_config$sort = config.sort) === null || _config$sort === void 0 ? void 0 : _config$sort.filter(sortEntry => {
      const [fieldName] = sortEntry;
      return isFieldIncludedInColumns(fieldName);
    });

    // Clean up grid configuration to only include columns that exist
    const cleanedGrid = (_config$grid = config.grid) !== null && _config$grid !== void 0 && _config$grid.columns ? {
      ...config.grid,
      columns: Object.fromEntries(Object.entries(config.grid.columns).filter(([fieldName]) => isFieldIncludedInColumns(fieldName)))
    } : config.grid;

    // Only include logs params with actual values to keep URLs clean
    const hasColumns = config.columns && config.columns.length > 0;
    const hasSort = cleanedSort && cleanedSort.length > 0;
    const hasGrid = cleanedGrid && Object.keys(cleanedGrid).length > 0;
    history.replace({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...currentQuery,
        // Only include params that have meaningful values
        logsColumns: hasColumns ? JSON.stringify(config.columns) : undefined,
        logsSort: hasSort ? JSON.stringify(cleanedSort) : undefined,
        logsGrid: hasGrid ? JSON.stringify(cleanedGrid) : undefined,
        logsRowHeight: config.rowHeight,
        logsRowsPerPage: config.rowsPerPage,
        logsDensity: config.density
      })
    });
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_resetting_height_container.ResettingHeightRetainer, {
    reset: !traceId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmTransactionDistributionTabContent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_distribution_chart_with_scrubber.DurationDistributionChartWithScrubber, {
    onChartSelection: onChartSelection,
    onClearSelection: onClearSelection,
    selection: selection,
    status: status,
    markerCurrentEvent: markerCurrentEvent,
    chartData: chartData,
    totalDocCount: totalDocCount,
    hasData: hasData,
    percentileThresholdValue: percentileThresholdValue,
    eventType: _common.ProcessorEvent.transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_waterfall_with_summary.WaterfallWithSummary, {
    environment: environment,
    onSampleClick: onSampleClick,
    onTabClick: onTabClick,
    serviceName: serviceName,
    waterfallItemId: waterfallItemId,
    detailTab: detailTab,
    waterfallFetchResult: waterfallFetchResult.waterfall,
    waterfallFetchStatus: waterfallFetchResult.status,
    traceSamplesFetchStatus: traceSamplesFetchResult.status,
    traceSamples: (_traceSamplesFetchRes = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes === void 0 ? void 0 : _traceSamplesFetchRes.traceSamples,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange,
    logsTableConfig: logsTableConfig,
    onLogsTableConfigChange: onLogsTableConfigChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  })));
}