"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlEnvironmentFilter = getEsqlEnvironmentFilter;
var _ = require(".");
var _environment_filter_values = require("../../environment_filter_values");
var _apm = require("../../es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEsqlEnvironmentFilter(environment) {
  if (environment === _environment_filter_values.ENVIRONMENT_ALL.value) {
    return '';
  }
  if (environment === _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value) {
    return `${(0, _.identifier)`${_apm.SERVICE_ENVIRONMENT}`} IS NULL`;
  }
  return `${(0, _.identifier)`${_apm.SERVICE_ENVIRONMENT}`} == ${(0, _.string)`${environment}`}`;
}