"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRule = loadRule;
exports.loadRuleType = loadRuleType;
exports.loadRuleTypes = loadRuleTypes;
var _common = require("../../common");
var _common_transformations = require("../lib/common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadRuleTypes({
  http
}) {
  const res = await http.get(`${_common.BASE_ALERTING_API_PATH}/rule_types`);
  return res.map(ruleType => (0, _common_transformations.transformRuleType)(ruleType));
}
async function loadRuleType({
  http,
  id
}) {
  const ruleTypes = await loadRuleTypes({
    http
  });
  return ruleTypes.find(type => type.id === id);
}
async function loadRule({
  http,
  ruleId
}) {
  const res = await http.get(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/rule/${ruleId}`);
  return (0, _common_transformations.transformRule)(res);
}