"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useArchiveMaintenanceWindow = useArchiveMaintenanceWindow;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _kibana_react = require("../utils/kibana_react");
var _archive = require("../services/maintenance_windows_api/archive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useArchiveMaintenanceWindow() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const mutationFn = ({
    maintenanceWindowId,
    archive
  }) => {
    return (0, _archive.archiveMaintenanceWindow)({
      http,
      maintenanceWindowId,
      archive
    });
  };
  return (0, _reactQuery.useMutation)(mutationFn, {
    onSuccess: (data, {
      archive
    }) => {
      const archiveToast = _i18n.i18n.translate('xpack.alerting.maintenanceWindowsArchiveSuccess', {
        defaultMessage: "Archived maintenance window ''{title}''",
        values: {
          title: data.title
        }
      });
      const unarchiveToast = _i18n.i18n.translate('xpack.alerting.maintenanceWindowsUnarchiveSuccess', {
        defaultMessage: "Unarchived maintenance window ''{title}''",
        values: {
          title: data.title
        }
      });
      toasts.addSuccess(archive ? archiveToast : unarchiveToast);
    },
    onError: (error, {
      archive
    }) => {
      const archiveToast = _i18n.i18n.translate('xpack.alerting.maintenanceWindowsArchiveFailure', {
        defaultMessage: 'Failed to archive maintenance window.'
      });
      const unarchiveToast = _i18n.i18n.translate('xpack.alerting.maintenanceWindowsUnarchiveFailure', {
        defaultMessage: 'Failed to unarchive maintenance window.'
      });
      toasts.addDanger(archive ? archiveToast : unarchiveToast);
    }
  });
}