"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoute = void 0;
var _schema_v = require("@kbn/aiops-log-rate-analysis/api/schema_v3");
var _constants = require("@kbn/aiops-common/constants");
var _route_handler_factory = require("./route_handler_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * `defineRoute` is called in the root `plugin.ts` to set up the API route
 * for field candidates. Its purpose is to take care of the route setup
 * and versioning only. `routeHandlerFactory` is used to take care of
 * the actual route logic.
 */
const defineRoute = (router, license, coreStart, usageCounter) => {
  router.versioned.post({
    path: _constants.AIOPS_API_ENDPOINT.LOG_RATE_ANALYSIS_FIELD_CANDIDATES,
    access: 'internal',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _schema_v.aiopsLogRateAnalysisSchemaV3
      }
    }
  }, (0, _route_handler_factory.routeHandlerFactory)('1', license, coreStart, usageCounter));
};
exports.defineRoute = defineRoute;