"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describeDataset = describeDataset;
var _esQuery = require("@kbn/es-query");
var _get_sample_documents = require("./get_sample_documents");
var _merge_sample_documents_with_field_caps = require("./merge_sample_documents_with_field_caps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function describeDataset({
  esClient,
  start,
  end,
  index,
  kql,
  filter,
  sampleDocsSize
}) {
  const [fieldCaps, hits] = await Promise.all([esClient.fieldCaps({
    index,
    fields: '*',
    index_filter: {
      bool: {
        filter: (0, _esQuery.dateRangeQuery)(start, end)
      }
    }
  }), (0, _get_sample_documents.getSampleDocuments)({
    esClient,
    index,
    start,
    end,
    kql,
    filter,
    size: sampleDocsSize
  })]);
  const total = hits.total;
  const analysis = (0, _merge_sample_documents_with_field_caps.mergeSampleDocumentsWithFieldCaps)({
    hits: hits.hits,
    total: total !== null && total !== void 0 ? total : 0,
    fieldCaps
  });
  return analysis;
}