"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildManagedMetadataFromMaybeManagedMetadata = buildManagedMetadataFromMaybeManagedMetadata;
const ClassElementMetadataKind_1 = require("../models/ClassElementMetadataKind");
const assertMetadataFromTypescriptIfManaged_1 = require("./assertMetadataFromTypescriptIfManaged");
function buildManagedMetadataFromMaybeManagedMetadata(metadata, kind, serviceIdentifier, options) {
    (0, assertMetadataFromTypescriptIfManaged_1.assertMetadataFromTypescriptIfManaged)(metadata);
    if (kind === ClassElementMetadataKind_1.ClassElementMetadataKind.multipleInjection) {
        return {
            ...metadata,
            chained: options?.chained ?? false,
            kind,
            value: serviceIdentifier,
        };
    }
    else {
        return {
            ...metadata,
            kind,
            value: serviceIdentifier,
        };
    }
}
//# sourceMappingURL=buildManagedMetadataFromMaybeManagedMetadata.js.map