"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHeaderLogoStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _title = require("../../title/title.styles");
var _header = require("../header.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHeaderLogoStyles = exports.euiHeaderLogoStyles = function euiHeaderLogoStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiHeaderVariables = (0, _header.euiHeaderVariables)(euiThemeContext),
    childHeight = _euiHeaderVariables.childHeight;
  return {
    euiHeaderLogo: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('height', childHeight), " line-height:", childHeight, ";", (0, _global_styling.logicalCSS)('min-width', childHeight), " padding-inline:", euiTheme.size.s, ";display:inline-flex;border-radius:", euiTheme.border.radius.small, ";align-items:center;white-space:nowrap;", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs']), "{", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.xs), ";};label:euiHeaderLogo;"),
    euiHeaderLogo__text: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxs'), " ", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.base), " ", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs']), "{", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.s), ";};label:euiHeaderLogo__text;")
  };
};