"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiFlyoutZIndex = void 0;
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @internal
 */

var calculateZIndex = function calculateZIndex(baseLevel, isChildFlyout) {
  var level = Number(baseLevel);
  return {
    // Child flyouts slide in from below and need to have a lower z-index
    flyoutZIndex: isChildFlyout ? level - 1 : level,
    maskZIndex: level - 2
  };
};

/**
 * @internal
 */
var useEuiFlyoutZIndex = exports.useEuiFlyoutZIndex = function useEuiFlyoutZIndex(_ref) {
  var maskProps = _ref.maskProps,
    isPushed = _ref.isPushed,
    managedFlyoutIndex = _ref.managedFlyoutIndex,
    isChildFlyout = _ref.isChildFlyout;
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  var baseLevel = Number(euiTheme.levels.flyout);

  // The default headerZindexLocation for EuiFlyout is "below"
  // which is different from what EuiOverlayMask fallbacks to - see
  // _flyout_overlay.tsx.
  // We set z-index to mask level only when explicitly overridden
  // via the maskProps prop
  if (!isPushed && (maskProps === null || maskProps === void 0 ? void 0 : maskProps.headerZindexLocation) === 'above') {
    baseLevel = Number(euiTheme.levels.mask);
  }
  baseLevel += managedFlyoutIndex;
  return calculateZIndex(baseLevel, isChildFlyout);
};