"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STAGE_RETURNING = exports.STAGE_OPENING = exports.STAGE_INACTIVE = exports.STAGE_CLOSING = exports.STAGE_BACKGROUNDING = exports.STAGE_BACKGROUNDED = exports.STAGE_ACTIVE = exports.SESSION_START = exports.SESSION_NEVER = exports.SESSION_INHERIT = exports.PROPERTY_LEVEL = exports.PROPERTY_LAYOUT_MODE = exports.PROPERTY_FLYOUT = exports.LEVEL_MAIN = exports.LEVEL_CHILD = exports.LAYOUT_MODE_STACKED = exports.LAYOUT_MODE_SIDE_BY_SIDE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Allowed values for `session` prop to control the way the session is managed for a flyout.
 */
var SESSION_START = exports.SESSION_START = 'start';
var SESSION_INHERIT = exports.SESSION_INHERIT = 'inherit';
var SESSION_NEVER = exports.SESSION_NEVER = 'never';
var PREFIX = 'data-managed-flyout';

/**
 * Data attribute applied to a managed flyout element to help identify it as a managed flyout.
 */
var PROPERTY_FLYOUT = exports.PROPERTY_FLYOUT = "".concat(PREFIX);

/**
 * Data attribute indicating whether the flyout is the `main` or `child` flyout.
 */
var PROPERTY_LEVEL = exports.PROPERTY_LEVEL = "".concat(PREFIX, "-level");

/**
 * Data attribute representing how multiple flyouts are laid out
 * (`side-by-side` or `stacked`).
 */
var PROPERTY_LAYOUT_MODE = exports.PROPERTY_LAYOUT_MODE = "".concat(PREFIX, "-layout-mode");

/** Stacked layout mode where child flyouts overlay on top of the main flyout. */
var LAYOUT_MODE_STACKED = exports.LAYOUT_MODE_STACKED = 'stacked';
/** Side-by-side layout mode where child flyouts render adjacent to the main flyout. */
var LAYOUT_MODE_SIDE_BY_SIDE = exports.LAYOUT_MODE_SIDE_BY_SIDE = 'side-by-side';

/** The primary (parent) flyout in a session. */
var LEVEL_MAIN = exports.LEVEL_MAIN = 'main';
/** The secondary (child) flyout spawned by the main flyout. */
var LEVEL_CHILD = exports.LEVEL_CHILD = 'child';

/** Flyout is mounting and playing its opening animation. */
var STAGE_OPENING = exports.STAGE_OPENING = 'opening';
/** Flyout is fully visible and interactive. */
var STAGE_ACTIVE = exports.STAGE_ACTIVE = 'active';
/** Flyout is unmounted or not currently visible/interactable. */
var STAGE_INACTIVE = exports.STAGE_INACTIVE = 'inactive';
/** Main flyout is transitioning behind an active session flyout. */
var STAGE_BACKGROUNDING = exports.STAGE_BACKGROUNDING = 'backgrounding';
/** Main flyout is backgrounded behind an active session flyout. */
var STAGE_BACKGROUNDED = exports.STAGE_BACKGROUNDED = 'backgrounded';
/** Flyout is returning to the foreground from a backgrounded state. */
var STAGE_RETURNING = exports.STAGE_RETURNING = 'returning';
/** Flyout is playing its closing animation. */
var STAGE_CLOSING = exports.STAGE_CLOSING = 'closing';