"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyout = void 0;
Object.defineProperty(exports, "FLYOUT_PADDING_SIZES", {
  enumerable: true,
  get: function get() {
    return _const2.FLYOUT_PADDING_SIZES;
  }
});
Object.defineProperty(exports, "FLYOUT_SIDES", {
  enumerable: true,
  get: function get() {
    return _const2.FLYOUT_SIDES;
  }
});
Object.defineProperty(exports, "FLYOUT_SIZES", {
  enumerable: true,
  get: function get() {
    return _const2.FLYOUT_SIZES;
  }
});
Object.defineProperty(exports, "FLYOUT_TYPES", {
  enumerable: true,
  get: function get() {
    return _const2.FLYOUT_TYPES;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _component_defaults = require("../provider/component_defaults");
var _flyout = require("./flyout.component");
var _manager = require("./manager");
var _flyout_menu_context = require("./flyout_menu_context");
var _flyout_parent_context = require("./flyout_parent_context");
var _const = require("./manager/const");
var _react2 = require("@emotion/react");
var _const2 = require("./const");
var _excluded = ["as", "onClose", "onActive", "session"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFlyout = exports.EuiFlyout = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var _usePropsWithComponen = (0, _component_defaults.usePropsWithComponentDefaults)('EuiFlyout', props),
    as = _usePropsWithComponen.as,
    onClose = _usePropsWithComponen.onClose,
    onActive = _usePropsWithComponen.onActive,
    session = _usePropsWithComponen.session,
    rest = _objectWithoutProperties(_usePropsWithComponen, _excluded);
  var hasActiveSession = (0, _manager.useHasActiveSession)();
  var isInsideParentFlyout = (0, _flyout_parent_context.useIsInsideParentFlyout)();
  var isUnmanagedFlyout = (0, _react.useRef)(false);

  /*
   * Flyout routing logic:
   * - session="start" → Main flyout (creates new session)
   * - session="inherit" + active session → Child flyout (auto-joins, works across React roots!)
   * - session="inherit" + no session → Standard flyout
   * - session="never" → Standard flyout (explicit opt-out)
   * - session=undefined + inside parent + active session → Child flyout (auto-inherit)
   * - session=undefined + not inside parent → Standard flyout (default behavior)
   */

  // Determine effective session behavior when session is undefined
  var effectiveSession = session === undefined && isInsideParentFlyout && hasActiveSession ? _const.SESSION_INHERIT : session !== null && session !== void 0 ? session : _const.SESSION_NEVER;
  if (effectiveSession !== _const.SESSION_NEVER) {
    if (effectiveSession === _const.SESSION_START) {
      // session=start: create new session
      if (isUnmanagedFlyout.current) {
        // TODO: @tkajtoch - We need to find a better way to handle the missing event.
        onClose === null || onClose === void 0 || onClose({});
        return null;
      }
      return (0, _react2.jsx)(_manager.EuiFlyoutMain, _extends({}, rest, {
        onClose: onClose,
        onActive: onActive,
        as: "div"
      }));
    }

    // session=inherit: auto-join existing session as child
    if (hasActiveSession && effectiveSession === _const.SESSION_INHERIT) {
      return (0, _react2.jsx)(_manager.EuiFlyoutChild, _extends({}, rest, {
        onClose: onClose,
        onActive: onActive,
        as: "div"
      }));
    }
  }
  isUnmanagedFlyout.current = true;
  return (0, _react2.jsx)(_flyout_menu_context.EuiFlyoutMenuContext.Provider, {
    value: {
      onClose: onClose
    }
  }, (0, _react2.jsx)(_flyout.EuiFlyoutComponent, _extends({}, rest, {
    onClose: onClose,
    as: as,
    ref: ref
  })));
});
EuiFlyout.propTypes = {
  /**
     * Controls the way the session is managed for this flyout.
     * - `start`: Creates a new flyout session. Use this for the main flyout.
     * - `inherit`: Inherits an existing session if one is active, otherwise functions as a standard flyout.
     * - `never`: Disregards session management and always functions as a standard flyout.
     *
     * When the `session` prop is undefined (not set), the flyout will automatically inherit from
     * a parent flyout if it's nested inside one. Otherwise, it defaults to `never`.
     *
     * Check out [EuiFlyout session management](https://eui.elastic.co/docs/components/containers/flyout/session-management)
     * documentation to learn more.
     * @default undefined (auto-inherit when nested, otherwise 'never')
     */
  session: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  /**
     * Callback fired when the flyout becomes active/visible, which may happen programmatically from history navigation.
     */
  onActive: _propTypes.default.func,
  /**
     * The HTML element to render as the flyout container.
     */
  as: _propTypes.default.any
};
EuiFlyout.displayName = 'EuiFlyout';