"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShadowColor = exports.boxShadowToFilterDropShadow = void 0;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _types = require("../../services/theme/types");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Create a CSS color value using whose opacity is determined based
// on either a light or dark theme. We use a multiplier
// of 1 for light themes and 3.5 for dark themes
var getShadowColor = exports.getShadowColor = function getShadowColor(color, opacity, colorMode) {
  var themeOpacity = colorMode === _types.COLOR_MODES_STANDARD.dark ? opacity * 3.5 : opacity * 1;
  return (0, _chromaJs["default"])(color).alpha(themeOpacity).css();
};

/**
 * Converts a `box-shadow` string to a `filter: drop-shadow()` string.
 *
 * @todo check whether this is actually needed in +2025, the original code replacing
 * box-shadow with filter: drop-shadow() had the following comment:
 * > Using only one drop-shadow filter instead of multiple is more
 * > performant & prevents Safari bugs
 *
 * @param boxShadow The `box-shadow` string to convert.
 * @returns The converted `filter` string.
 */
var boxShadowToFilterDropShadow = exports.boxShadowToFilterDropShadow = function boxShadowToFilterDropShadow(boxShadow) {
  var dropShadows = boxShadow.split(/,(?![^(]*\))/) // split by comma, but not inside parentheses
  .map(function (shadow) {
    shadow = shadow.trim();
    // remove `inset`, not supported by drop-shadow
    if (shadow.startsWith('inset ')) {
      shadow = shadow.slice(6);
    }
    // can be complex (hsl, rgb, etc.), used AI for this
    var colorMatch = shadow.match(/(hsl|rgb)a?\(.*\)|#[0-9a-fA-F]{3,8}|[a-zA-Z]+$/);
    var color;
    var parts;
    if (colorMatch) {
      color = colorMatch[0];
      parts = shadow.substring(0, colorMatch.index).trim().split(/\s+/);
    } else {
      color = '#000'; // fallback to black
      parts = shadow.trim().split(/\s+/);
    }
    // drop-shadow doesn't support spread, so we only take x, y, blur
    var _parts = parts,
      _parts2 = _slicedToArray(_parts, 3),
      x = _parts2[0],
      y = _parts2[1],
      blur = _parts2[2];
    return "drop-shadow(".concat(x, " ").concat(y, " ").concat(blur, " ").concat(color, ")");
  }).join(' ');
  return "filter: ".concat(dropShadows, ";");
};