"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = SearchTemplateApi;
const commonQueryParams = ['error_trace', 'filter_path', 'human', 'pretty'];
const acceptedParams = {
    search_template: {
        path: [
            'index'
        ],
        body: [
            'explain',
            'id',
            'params',
            'profile',
            'source'
        ],
        query: [
            'allow_no_indices',
            'ccs_minimize_roundtrips',
            'expand_wildcards',
            'explain',
            'ignore_throttled',
            'ignore_unavailable',
            'preference',
            'profile',
            'project_routing',
            'routing',
            'scroll',
            'search_type',
            'rest_total_hits_as_int',
            'typed_keys'
        ]
    }
};
async function SearchTemplateApi(params, options) {
    const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = acceptedParams.search_template;
    const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
    const querystring = userQuery != null ? { ...userQuery } : {};
    let body;
    const userBody = params === null || params === void 0 ? void 0 : params.body;
    if (userBody != null) {
        if (typeof userBody === 'string') {
            body = userBody;
        }
        else {
            body = { ...userBody };
        }
    }
    params = params !== null && params !== void 0 ? params : {};
    for (const key in params) {
        if (acceptedBody.includes(key)) {
            body = body !== null && body !== void 0 ? body : {};
            // @ts-expect-error
            body[key] = params[key];
        }
        else if (acceptedPath.includes(key)) {
            continue;
        }
        else if (key !== 'body' && key !== 'querystring') {
            if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                // @ts-expect-error
                querystring[key] = params[key];
            }
            else {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
        }
    }
    let method = '';
    let path = '';
    if (params.index != null) {
        method = body != null ? 'POST' : 'GET';
        path = `/${encodeURIComponent(params.index.toString())}/_search/template`;
    }
    else {
        method = body != null ? 'POST' : 'GET';
        path = '/_search/template';
    }
    const meta = {
        name: 'search_template',
        pathParts: {
            index: params.index
        },
        acceptedParams: [
            'index',
            'explain',
            'id',
            'params',
            'profile',
            'source',
            'allow_no_indices',
            'ccs_minimize_roundtrips',
            'expand_wildcards',
            'explain',
            'ignore_throttled',
            'ignore_unavailable',
            'preference',
            'profile',
            'project_routing',
            'routing',
            'scroll',
            'search_type',
            'rest_total_hits_as_int',
            'typed_keys'
        ]
    };
    return await this.transport.request({ path, method, querystring, body, meta }, options);
}
//# sourceMappingURL=search_template.js.map