"use strict";
/*
 * Copyright Elasticsearch B.V. and contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = CountApi;
const commonQueryParams = ['error_trace', 'filter_path', 'human', 'pretty'];
const acceptedParams = {
    count: {
        path: [
            'index'
        ],
        body: [
            'query'
        ],
        query: [
            'allow_no_indices',
            'analyzer',
            'analyze_wildcard',
            'default_operator',
            'df',
            'expand_wildcards',
            'ignore_throttled',
            'ignore_unavailable',
            'lenient',
            'min_score',
            'preference',
            'project_routing',
            'routing',
            'terminate_after',
            'q'
        ]
    }
};
async function CountApi(params, options) {
    const { path: acceptedPath, body: acceptedBody, query: acceptedQuery } = acceptedParams.count;
    const userQuery = params === null || params === void 0 ? void 0 : params.querystring;
    const querystring = userQuery != null ? { ...userQuery } : {};
    let body;
    const userBody = params === null || params === void 0 ? void 0 : params.body;
    if (userBody != null) {
        if (typeof userBody === 'string') {
            body = userBody;
        }
        else {
            body = { ...userBody };
        }
    }
    params = params !== null && params !== void 0 ? params : {};
    for (const key in params) {
        if (acceptedBody.includes(key)) {
            body = body !== null && body !== void 0 ? body : {};
            // @ts-expect-error
            body[key] = params[key];
        }
        else if (acceptedPath.includes(key)) {
            continue;
        }
        else if (key !== 'body' && key !== 'querystring') {
            if (acceptedQuery.includes(key) || commonQueryParams.includes(key)) {
                // @ts-expect-error
                querystring[key] = params[key];
            }
            else {
                body = body !== null && body !== void 0 ? body : {};
                // @ts-expect-error
                body[key] = params[key];
            }
        }
    }
    let method = '';
    let path = '';
    if (params.index != null) {
        method = body != null ? 'POST' : 'GET';
        path = `/${encodeURIComponent(params.index.toString())}/_count`;
    }
    else {
        method = body != null ? 'POST' : 'GET';
        path = '/_count';
    }
    const meta = {
        name: 'count',
        pathParts: {
            index: params.index
        },
        acceptedParams: [
            'index',
            'query',
            'allow_no_indices',
            'analyzer',
            'analyze_wildcard',
            'default_operator',
            'df',
            'expand_wildcards',
            'ignore_throttled',
            'ignore_unavailable',
            'lenient',
            'min_score',
            'preference',
            'project_routing',
            'routing',
            'terminate_after',
            'q'
        ]
    };
    return await this.transport.request({ path, method, querystring, body, meta }, options);
}
//# sourceMappingURL=count.js.map