"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentPoliciesRoute = void 0;
var _pMap = _interopRequireDefault(require("p-map"));
var _lodash = require("lodash");
var _semver = require("semver");
var _common = require("@kbn/fleet-plugin/common");
var _common2 = require("@kbn/spaces-plugin/common");
var _get_internal_saved_object_client = require("../../utils/get_internal_saved_object_client");
var _constants = require("../../../common/constants");
var _common3 = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentPoliciesRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'internal',
    path: '/internal/osquery/fleet_wrapper/agent_policies',
    security: {
      authz: {
        requiredPrivileges: [`${_common3.PLUGIN_ID}-read`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {}
  }, async (context, request, response) => {
    var _await$packagePolicyS;
    const spaceScopedClient = await (0, _get_internal_saved_object_client.createInternalSavedObjectsClientForSpaceId)(osqueryContext, request);
    const space = await osqueryContext.service.getActiveSpace(request);
    const agentService = osqueryContext.service.getAgentService();
    const agentPolicyService = osqueryContext.service.getAgentPolicyService();
    const packagePolicyService = osqueryContext.service.getPackagePolicyService();
    const {
      items: packagePolicies
    } = (_await$packagePolicyS = await (packagePolicyService === null || packagePolicyService === void 0 ? void 0 : packagePolicyService.list(spaceScopedClient, {
      kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_common3.OSQUERY_INTEGRATION_NAME}`,
      perPage: 1000,
      page: 1
    }))) !== null && _await$packagePolicyS !== void 0 ? _await$packagePolicyS : {
      items: []
    };
    const supportedPackagePolicyIds = (0, _lodash.filter)(packagePolicies, packagePolicy => {
      var _packagePolicy$packag, _packagePolicy$packag2;
      return (0, _semver.satisfies)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.version) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', '>=0.6.0');
    });
    const agentPolicyIds = (0, _lodash.uniq)((0, _lodash.flatMap)(supportedPackagePolicyIds, 'policy_ids'));
    const agentPolicies = await (agentPolicyService === null || agentPolicyService === void 0 ? void 0 : agentPolicyService.getByIds(spaceScopedClient, agentPolicyIds));
    if (agentPolicies !== null && agentPolicies !== void 0 && agentPolicies.length) {
      await (0, _pMap.default)(agentPolicies, agentPolicy => {
        var _space$id;
        return agentService === null || agentService === void 0 ? void 0 : agentService.asInternalScopedUser((_space$id = space === null || space === void 0 ? void 0 : space.id) !== null && _space$id !== void 0 ? _space$id : _common2.DEFAULT_SPACE_ID).getAgentStatusForAgentPolicy(agentPolicy.id).then(({
          active: agentTotal
        }) => agentPolicy.agents = agentTotal);
      }, {
        concurrency: 10
      });
    }
    return response.ok({
      body: agentPolicies
    });
  });
};
exports.getAgentPoliciesRoute = getAgentPoliciesRoute;