"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllLiveQueries = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _search_strategy = require("../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Make sure we keep this and ACTIONS_QUERY_KEY in osquery_flyout.tsx in sync.
const ACTIONS_QUERY_KEY = 'actions';
const useAllLiveQueries = ({
  activePage = 0,
  direction = _search_strategy.Direction.desc,
  limit = 100,
  sortField = '@timestamp',
  kuery,
  skip = false,
  alertId
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)([ACTIONS_QUERY_KEY, {
    activePage,
    direction,
    limit,
    sortField,
    ...(alertId ? {
      alertId
    } : {})
  }], () => http.get('/api/osquery/live_queries', {
    version: _constants.API_VERSIONS.public.v1,
    query: {
      kuery,
      page: activePage,
      pageSize: limit,
      sort: sortField,
      sortOrder: direction
    }
  }), {
    keepPreviousData: true,
    enabled: !skip,
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.live_queries_all.fetchError', {
        defaultMessage: 'Error while fetching live queries'
      })
    })
  });
};
exports.useAllLiveQueries = useAllLiveQueries;