"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _allow_lists = require("@kbn/onechat-server/allow_lists");
var _spaces = require("../../utils/spaces");
var _builtin = require("./builtin");
var _tool_types = require("./tool_types");
var _definitions = require("./tool_types/definitions");
var _persisted = require("./persisted");
var _tool_registry = require("./tool_registry");
var _health = require("./health");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ToolsService {
  constructor() {
    (0, _defineProperty2.default)(this, "setupDeps", void 0);
    (0, _defineProperty2.default)(this, "builtinRegistry", void 0);
    this.builtinRegistry = (0, _builtin.createBuiltinToolRegistry)();
  }
  setup(deps) {
    this.setupDeps = deps;
    return {
      register: reg => {
        if (!(0, _allow_lists.isAllowedBuiltinTool)(reg.id)) {
          throw new Error(`Built-in tool with id "${reg.id}" is not in the list of allowed built-in tools.
             Please add it to the list of allowed built-in tools in the "@kbn/onechat-server/allow_lists.ts" file.`);
        }
        return this.builtinRegistry.register(reg);
      }
    };
  }
  start({
    getRunner,
    elasticsearch,
    spaces,
    uiSettings,
    savedObjects,
    actions
  }) {
    const {
      logger,
      workflowsManagement
    } = this.setupDeps;
    const toolTypes = (0, _tool_types.getToolTypeDefinitions)({
      workflowsManagement,
      actions
    });

    // Compute the set of tool types that have health tracking enabled
    const healthTrackedToolTypes = new Set(toolTypes.filter(_definitions.isEnabledDefinition).filter(def => def.trackHealth === true).map(def => def.toolType));
    const builtinProviderFn = (0, _builtin.createBuiltinProviderFn)({
      registry: this.builtinRegistry,
      toolTypes
    });
    const persistedProviderFn = (0, _persisted.createPersistedProviderFn)({
      logger,
      esClient: elasticsearch.client.asInternalUser,
      toolTypes
    });
    const getRegistry = async ({
      request
    }) => {
      const space = (0, _spaces.getCurrentSpaceId)({
        request,
        spaces
      });
      const builtinProvider = await builtinProviderFn({
        request,
        space
      });
      const persistedProvider = await persistedProviderFn({
        request,
        space
      });
      const healthClient = (0, _health.createToolHealthClient)({
        space,
        logger,
        esClient: elasticsearch.client.asInternalUser
      });
      return (0, _tool_registry.createToolRegistry)({
        getRunner,
        space,
        request,
        builtinProvider,
        persistedProvider,
        uiSettings,
        savedObjects,
        healthClient,
        healthTrackedToolTypes
      });
    };
    const getHealthClient = ({
      request
    }) => {
      const space = (0, _spaces.getCurrentSpaceId)({
        request,
        spaces
      });
      return (0, _health.createToolHealthClient)({
        space,
        logger,
        esClient: elasticsearch.client.asInternalUser
      });
    };
    return {
      getRegistry,
      getToolDefinitions: () => toolTypes,
      getHealthClient
    };
  }
}
exports.ToolsService = ToolsService;