"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromEs = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts an Elasticsearch document to an application-level ToolHealthState.
 */
const fromEs = doc => {
  const source = doc._source;
  return {
    toolId: source.tool_id,
    status: source.status,
    lastCheck: source.last_check,
    errorMessage: source.error_message || undefined,
    consecutiveFailures: source.consecutive_failures
  };
};
exports.fromEs = fromEs;