"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tools = require("./tools");
var _agents = require("./agents");
var _runner = require("./runner");
var _conversation = require("./conversation");
var _chat = require("./chat");
var _attachments = require("./attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServiceManager {
  constructor() {
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "internalSetup", void 0);
    (0, _defineProperty2.default)(this, "internalStart", void 0);
  }
  setupServices({
    logger,
    workflowsManagement
  }) {
    this.services = {
      tools: new _tools.ToolsService(),
      agents: new _agents.AgentsService(),
      attachments: (0, _attachments.createAttachmentService)()
    };
    this.internalSetup = {
      tools: this.services.tools.setup({
        logger,
        workflowsManagement
      }),
      agents: this.services.agents.setup({
        logger
      }),
      attachments: this.services.attachments.setup()
    };
    return this.internalSetup;
  }
  startServices({
    logger,
    security,
    spaces,
    elasticsearch,
    inference,
    uiSettings,
    savedObjects,
    actions,
    trackingService,
    analyticsService
  }) {
    if (!this.services) {
      throw new Error('#startServices called before #setupServices');
    }

    // eslint-disable-next-line prefer-const
    let runner;
    const getRunner = () => {
      if (!runner) {
        throw new Error('Trying to access runner before initialization');
      }
      return runner;
    };
    const attachments = this.services.attachments.start();
    const tools = this.services.tools.start({
      getRunner,
      spaces,
      elasticsearch,
      uiSettings,
      savedObjects,
      actions
    });
    const agents = this.services.agents.start({
      spaces,
      security,
      elasticsearch,
      uiSettings,
      savedObjects,
      getRunner,
      toolsService: tools
    });
    const runnerFactory = new _runner.RunnerFactoryImpl({
      logger: logger.get('runnerFactory'),
      security,
      elasticsearch,
      inference,
      spaces,
      actions,
      toolsService: tools,
      agentsService: agents,
      attachmentsService: attachments,
      trackingService
    });
    runner = runnerFactory.getRunner();
    const conversations = new _conversation.ConversationServiceImpl({
      logger: logger.get('conversations'),
      security,
      elasticsearch,
      spaces
    });
    const chat = (0, _chat.createChatService)({
      logger: logger.get('chat'),
      inference,
      conversationService: conversations,
      agentService: agents,
      uiSettings,
      savedObjects,
      trackingService,
      analyticsService
    });
    this.internalStart = {
      tools,
      agents,
      attachments,
      conversations,
      runnerFactory,
      chat
    };
    return this.internalStart;
  }
}
exports.ServiceManager = ServiceManager;