"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateRequestToEs = exports.fromEs = exports.createRequestToEs = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultAgentType = _onechatCommon.AgentType.chat;
const fromEs = document => {
  var _document$_source$con, _document$_source$id;
  if (!document._source) {
    throw new Error('No source found on get conversation response');
  }
  const configuration = (_document$_source$con = document._source.configuration) !== null && _document$_source$con !== void 0 ? _document$_source$con : document._source.config;
  return {
    // backward compatibility with M1 - we check the document id.
    id: (_document$_source$id = document._source.id) !== null && _document$_source$id !== void 0 ? _document$_source$id : document._id,
    type: document._source.type,
    name: document._source.name,
    description: document._source.description,
    labels: document._source.labels,
    avatar_color: document._source.avatar_color,
    avatar_symbol: document._source.avatar_symbol,
    configuration: {
      instructions: configuration.instructions,
      tools: configuration.tools
    }
  };
};
exports.fromEs = fromEs;
const createRequestToEs = ({
  profile,
  space,
  creationDate
}) => {
  return {
    id: profile.id,
    name: profile.name,
    type: defaultAgentType,
    space,
    description: profile.description,
    labels: profile.labels,
    avatar_color: profile.avatar_color,
    avatar_symbol: profile.avatar_symbol,
    config: {
      instructions: profile.configuration.instructions,
      tools: profile.configuration.tools
    },
    created_at: creationDate.toISOString(),
    updated_at: creationDate.toISOString()
  };
};
exports.createRequestToEs = createRequestToEs;
const updateRequestToEs = ({
  agentId,
  currentProps,
  update,
  updateDate
}) => {
  var _currentProps$configu;
  const currentConfig = (_currentProps$configu = currentProps.configuration) !== null && _currentProps$configu !== void 0 ? _currentProps$configu : currentProps.config;
  const updated = {
    ...currentProps,
    ...update,
    id: agentId,
    // Explicitly omit configuration to ensure migration
    configuration: undefined,
    config: {
      ...currentConfig,
      ...update.configuration
    },
    updated_at: updateDate.toISOString()
  };
  return updated;
};
exports.updateRequestToEs = updateRequestToEs;