"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateAnnotation = void 0;
var _langgraph = require("@langchain/langgraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StateAnnotation = exports.StateAnnotation = _langgraph.Annotation.Root({
  // inputs
  initialMessages: (0, _langgraph.Annotation)({
    reducer: _langgraph.messagesStateReducer,
    default: () => []
  }),
  cycleLimit: (0, _langgraph.Annotation)({
    reducer: (a, b) => b,
    default: () => 10
  }),
  // internals
  currentCycle: (0, _langgraph.Annotation)({
    reducer: (a, b) => b,
    default: () => 0
  }),
  // counter to keep track of the number of successive errors
  errorCount: (0, _langgraph.Annotation)({
    reducer: (a, b) => b,
    default: () => 0
  }),
  // list of actions/steps performed by the main agent
  mainActions: (0, _langgraph.Annotation)({
    reducer: (a, b) => [...a, ...b],
    default: () => []
  }),
  // list of actions/steps performed by the answer agent
  answerActions: (0, _langgraph.Annotation)({
    reducer: (a, b) => [...a, ...b],
    default: () => []
  }),
  // outputs
  finalAnswer: (0, _langgraph.Annotation)()
});