"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderVisualizationPrompt = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _visualizationUtils = require("@kbn/visualization-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderVisualizationPrompt = () => {
  const {
    tabularData,
    visualization
  } = _onechatCommon.ToolResultType;
  const {
    tagName,
    attributes
  } = _tool_result.visualizationElement;
  const chartTypeNames = Object.values(_visualizationUtils.ChartType).map(chartType => `\`${chartType}\``).join(', ');
  return `### RENDERING VISUALIZATIONS
      When a tool call returns a result of type "${tabularData}" or "${visualization}", you may render a visualization in the UI by emitting a custom XML element:

      <${tagName} ${attributes.toolResultId}="TOOL_RESULT_ID_HERE" />

      **Rules**
      * The \`<${tagName}>\` element must only be used to render tool results of type \`${tabularData}\` or \`${visualization}\`.
      * You can specify an optional chart type by adding the \`${attributes.chartType}\` attribute with one of the following values: ${chartTypeNames}. Only for "${tabularData}" type.
      * If the user does NOT specify a chart type in their message, you MUST omit the \`chart-type\` attribute. The system will choose an appropriate chart type automatically.
      * You must copy the \`tool_result_id\` from the tool's response into the \`${attributes.toolResultId}\` element attribute verbatim.
      * Do not invent, alter, or guess \`tool_result_id\`. You must use the exact id provided in the tool response.
      * You must not include any other attributes or content within the \`<${tagName}>\` element.

      **Example Usage:**

      Tool response includes:
      {
        "tool_result_id": "LiDoF1",
        "type": "${tabularData}",
        "data": {
          "source": "esql",
          "query": "FROM traces-apm* | STATS count() BY BUCKET(@timestamp, 1h)",
          "result": { "columns": [...], "values": [...] }
        }
      }

      To visualize this response your reply should be:
      <${tagName} ${attributes.toolResultId}="LiDoF1"/>

      To visualize this response as a bar chart your reply should be:
      <${tagName} ${attributes.toolResultId}="LiDoF1" ${attributes.chartType}="${_visualizationUtils.ChartType.Bar}"/>`;
};
exports.renderVisualizationPrompt = renderVisualizationPrompt;