"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPublicToolContract = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPublicToolContract = ({
  toolsService
}) => {
  return {
    get: async toolId => {
      return toolsService.get({
        toolId
      });
    },
    list: async () => {
      return toolsService.list();
    },
    execute: async ({
      toolId,
      toolParams,
      connectorId
    }) => {
      return toolsService.execute({
        toolId,
        toolParams,
        connectorId
      });
    }
  };
};
exports.createPublicToolContract = createPublicToolContract;