"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerApp = exports.registerAnalytics = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _telemetry = require("@kbn/onechat-common/telemetry");
var _features = require("../common/features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerApp = ({
  core,
  getServices
}) => {
  core.application.register({
    id: _features.ONECHAT_APP_ID,
    appRoute: _features.ONECHAT_PATH,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.enterpriseSearch,
    title: _features.AGENT_BUILDER_SHORT_TITLE,
    euiIconType: 'logoElasticsearch',
    visibleIn: ['sideNav', 'globalSearch'],
    keywords: ['agent builder', 'ai agent', 'chat agent'],
    deepLinks: [{
      id: 'conversations',
      path: '/conversations',
      title: _i18n.i18n.translate('xpack.onechat.chat.conversationsTitle', {
        defaultMessage: 'Agent Chat'
      })
    }, {
      id: 'tools',
      path: '/tools',
      title: _i18n.i18n.translate('xpack.onechat.tools.title', {
        defaultMessage: 'Tools'
      }),
      keywords: ['mcp']
    }, {
      id: 'agents',
      path: '/agents',
      title: _i18n.i18n.translate('xpack.onechat.agents.title', {
        defaultMessage: 'Agents'
      })
    }],
    async mount({
      element,
      history,
      onAppLeave
    }) {
      const {
        mountApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const [coreStart, startDependencies] = await core.getStartServices();
      coreStart.chrome.docTitle.change(_features.AGENT_BUILDER_FULL_TITLE);
      const services = getServices();
      return mountApp({
        core: coreStart,
        services,
        element,
        history,
        plugins: startDependencies,
        onAppLeave
      });
    }
  });
};
exports.registerApp = registerApp;
const registerAnalytics = ({
  analytics
}) => {
  _telemetry.agentBuilderPublicEbtEvents.forEach(eventConfig => {
    analytics.registerEventType(eventConfig);
  });
};
exports.registerAnalytics = registerAnalytics;