"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _doc_links = require("../common/doc_links");
var _register_locators = require("./locator/register_locators");
var _register = require("./register");
var _lazy_onechat_nav_control = require("./components/nav_control/lazy_onechat_nav_control");
var _services = require("./services");
var _attachments = require("./services/attachments");
var _tools = require("./services/tools");
var _step_types = require("./step_types");
var _agents = require("./services/agents");
var _open_conversation_flyout = require("./flyout/open_conversation_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class OnechatPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "conversationFlyoutActiveConfig", {});
    (0, _defineProperty2.default)(this, "internalServices", void 0);
    (0, _defineProperty2.default)(this, "setupServices", void 0);
    (0, _defineProperty2.default)(this, "activeFlyoutRef", null);
    (0, _defineProperty2.default)(this, "flyoutCallbacks", null);
    this.logger = context.logger.get();
  }
  setup(core, deps) {
    var _deps$licenseManageme;
    const navigationService = new _services.NavigationService({
      management: deps.management.locator,
      licenseManagement: (_deps$licenseManageme = deps.licenseManagement) === null || _deps$licenseManageme === void 0 ? void 0 : _deps$licenseManageme.locator
    });
    this.setupServices = {
      navigationService
    };
    (0, _register.registerApp)({
      core,
      getServices: () => {
        if (!this.internalServices) {
          throw new Error('getServices called before plugin start');
        }
        return this.internalServices;
      }
    });
    (0, _register.registerAnalytics)({
      analytics: core.analytics
    });
    (0, _register_locators.registerLocators)(deps.share);
    if (deps.workflowsExtensions) {
      (0, _step_types.registerStepDefinitions)(deps.workflowsExtensions);
    }
    return {};
  }
  start(core, startDependencies) {
    var _core$application$cap;
    const {
      http
    } = core;
    const {
      licensing,
      inference
    } = startDependencies;
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    const agentService = new _services.AgentService({
      http
    });
    const attachmentsService = new _services.AttachmentsService();
    const chatService = new _services.ChatService({
      http
    });
    const conversationsService = new _services.ConversationsService({
      http
    });
    const toolsService = new _services.ToolsService({
      http
    });
    const accessChecker = new _services.AgentBuilderAccessChecker({
      licensing,
      inference
    });
    if (!this.setupServices) {
      throw new Error('plugin start called before plugin setup');
    }
    const {
      navigationService
    } = this.setupServices;
    const internalServices = {
      agentService,
      attachmentsService,
      chatService,
      conversationsService,
      navigationService,
      toolsService,
      startDependencies,
      accessChecker
    };
    this.internalServices = internalServices;
    const hasAgentBuilder = ((_core$application$cap = core.application.capabilities.agentBuilder) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show) === true;
    const openFlyoutInternal = options => {
      const config = options !== null && options !== void 0 ? options : this.conversationFlyoutActiveConfig;

      // If a flyout is already open, update its props instead of creating a new one
      if (this.activeFlyoutRef && this.flyoutCallbacks) {
        this.flyoutCallbacks.updateProps(config);
        return {
          flyoutRef: this.activeFlyoutRef
        };
      }

      // Create new flyout and set up prop updates
      const {
        flyoutRef
      } = (0, _open_conversation_flyout.openConversationFlyout)(config, {
        coreStart: core,
        services: internalServices,
        onRegisterCallbacks: callbacks => {
          this.flyoutCallbacks = callbacks;
        },
        onClose: () => {
          this.activeFlyoutRef = null;
          this.flyoutCallbacks = null;
        }
      });
      this.activeFlyoutRef = flyoutRef;
      return {
        flyoutRef
      };
    };
    const onechatService = {
      agents: (0, _agents.createPublicAgentsContract)({
        agentService
      }),
      attachments: (0, _attachments.createPublicAttachmentContract)({
        attachmentsService
      }),
      tools: (0, _tools.createPublicToolContract)({
        toolsService
      }),
      setConversationFlyoutActiveConfig: config => {
        // set config until flyout is next opened
        this.conversationFlyoutActiveConfig = config;
        // if there is already an active flyout, update its props
        if (this.activeFlyoutRef && this.flyoutCallbacks) {
          this.flyoutCallbacks.updateProps(config);
          return {
            flyoutRef: this.activeFlyoutRef
          };
        }
      },
      clearConversationFlyoutActiveConfig: () => {
        this.conversationFlyoutActiveConfig = {};
        if (this.activeFlyoutRef && this.flyoutCallbacks) {
          // Removes stale browserApiTools from the flyout
          this.flyoutCallbacks.resetBrowserApiTools();
        }
      },
      openConversationFlyout: options => {
        return openFlyoutInternal(options);
      },
      toggleConversationFlyout: options => {
        if (this.activeFlyoutRef) {
          const flyoutRef = this.activeFlyoutRef;
          // Be defensive: clear local references immediately in case the underlying overlay doesn't
          // synchronously invoke our onClose callback.
          this.activeFlyoutRef = null;
          this.flyoutCallbacks = null;
          flyoutRef.close();
          return;
        }
        openFlyoutInternal(options);
      }
    };
    if (hasAgentBuilder) {
      core.chrome.navControls.registerRight({
        mount: element => {
          _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_lazy_onechat_nav_control.OnechatNavControlInitiator, {
            coreStart: core,
            pluginsStart: startDependencies,
            onechatService: onechatService,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 204,
              columnNumber: 13
            }
          }), element, () => {});
          return () => {
            _reactDom.default.unmountComponentAtNode(element);
          };
        },
        // right before the user profile
        order: 1001
      });
    }
    return onechatService;
  }
}
exports.OnechatPlugin = OnechatPlugin;