"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableAccessBoundary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_onechat_service = require("../application/hooks/use_onechat_service");
var _use_ui_privileges = require("../application/hooks/use_ui_privileges");
var _upgrade_license_prompt = require("../application/components/access/prompts/upgrade_license_prompt");
var _add_llm_connection_prompt = require("../application/components/access/prompts/add_llm_connection_prompt");
var _no_privilege_prompt = require("../application/components/access/prompts/no_privilege_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/embeddable/embeddable_access_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const closeButtonLabel = _i18n.i18n.translate('xpack.onechat.embeddable.accessBoundary.closeButton', {
  defaultMessage: 'Close'
});
const AccessDeniedWrapper = ({
  children,
  onClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerHeight = `calc(${euiTheme.size.xl} * 2)`;
  const headerStyles = (0, _react2.css)`
    display: flex;
    justify-content: flex-end;
    height: ${headerHeight};
    &.euiFlyoutHeader {
      padding: ${euiTheme.size.base};
    }
  `;
  const bodyStyles = (0, _react2.css)`
    flex: 1;
    min-height: 0;
    .euiFlyoutBody__overflowContent {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      height: 100%;
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    css: headerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, onClose && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": closeButtonLabel,
    onClick: onClose,
    "data-test-subj": "embeddableAccessBoundaryCloseButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: bodyStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, children));
};
const EmbeddableAccessBoundary = ({
  children,
  onClose
}) => {
  const {
    accessChecker
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    show: hasShowPrivilege
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const [accessState, setAccessState] = (0, _react.useState)({
    isLoading: true,
    hasRequiredLicense: false,
    hasLlmConnector: false
  });
  (0, _react.useEffect)(() => {
    const checkAccess = async () => {
      try {
        await accessChecker.initAccess();
        const {
          hasRequiredLicense,
          hasLlmConnector
        } = accessChecker.getAccess();
        setAccessState({
          isLoading: false,
          hasRequiredLicense,
          hasLlmConnector
        });
      } catch (error) {
        setAccessState({
          isLoading: false,
          hasRequiredLicense: false,
          hasLlmConnector: false
        });
      }
    };
    checkAccess();
  }, [accessChecker]);
  if (accessState.isLoading) {
    return /*#__PURE__*/_react.default.createElement(AccessDeniedWrapper, {
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }));
  }
  if (!accessState.hasRequiredLicense) {
    return /*#__PURE__*/_react.default.createElement(AccessDeniedWrapper, {
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_upgrade_license_prompt.UpgradeLicensePrompt, {
      variant: "embeddable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }));
  }
  if (!hasShowPrivilege) {
    return /*#__PURE__*/_react.default.createElement(AccessDeniedWrapper, {
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_no_privilege_prompt.NoPrivilegePrompt, {
      variant: "embeddable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }));
  }
  if (!accessState.hasLlmConnector) {
    return /*#__PURE__*/_react.default.createElement(AccessDeniedWrapper, {
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_add_llm_connection_prompt.AddLlmConnectionPrompt, {
      variant: "embeddable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }));
  }
  return children;
};
exports.EmbeddableAccessBoundary = EmbeddableAccessBoundary;