"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMcpToolToFormData = exports.transformMcpFormDataForUpdate = exports.transformMcpFormDataForCreate = exports.transformFormDataToMcpTool = void 0;
var _tools = require("@kbn/onechat-common/tools");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMcpToolToFormData = tool => {
  return {
    toolId: tool.id,
    description: tool.description,
    connectorId: tool.configuration.connector_id,
    mcpToolName: tool.configuration.tool_name,
    labels: tool.tags,
    type: _tools.ToolType.mcp
  };
};
exports.transformMcpToolToFormData = transformMcpToolToFormData;
const transformFormDataToMcpTool = data => {
  return {
    id: data.toolId,
    description: data.description,
    readonly: false,
    configuration: {
      connector_id: data.connectorId,
      tool_name: data.mcpToolName
    },
    tags: data.labels,
    type: _tools.ToolType.mcp
  };
};

// Form data → Create API payload
exports.transformFormDataToMcpTool = transformFormDataToMcpTool;
const transformMcpFormDataForCreate = data => {
  return (0, _lodash.omit)(transformFormDataToMcpTool(data), ['readonly']);
};

// Form data → Update API payload
exports.transformMcpFormDataForCreate = transformMcpFormDataForCreate;
const transformMcpFormDataForUpdate = data => {
  return (0, _lodash.omit)(transformFormDataToMcpTool(data), ['id', 'type', 'readonly']);
};
exports.transformMcpFormDataForUpdate = transformMcpFormDataForUpdate;