"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storageKeys = exports.AGENT_BUILDER_TOUR_STORAGE_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_BUILDER_TOUR_STORAGE_KEY = exports.AGENT_BUILDER_TOUR_STORAGE_KEY = 'agentBuilder.hasSeenTour';
const storageKeys = exports.storageKeys = {
  agentId: 'agentBuilder.agentId',
  lastUsedConnector: 'agentBuilder.lastUsedConnector',
  welcomeMessageDismissed: 'agentBuilder.welcomeMessageDismissed',
  hasSeenAgentBuilderTour: AGENT_BUILDER_TOUR_STORAGE_KEY,
  getLastConversationKey: (sessionTag, agentId) => {
    const tag = sessionTag || 'default';
    const agent = agentId || 'default';
    return `agentBuilder.lastConversation.${tag}.${agent}`;
  }
};