"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserToolExecutor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BrowserToolExecutor {
  constructor(toasts) {
    (0, _defineProperty2.default)(this, "toasts", void 0);
    this.toasts = toasts;
  }

  /**
   * Execute browser tool calls, tracking which have already been executed
   * to prevent re-execution on history load
   */
  async executeToolCalls(calls, tools) {
    for (const call of calls) {
      const tool = tools.get(call.tool_id);
      if (!tool) {
        continue;
      }
      try {
        const validatedParams = tool.schema.parse(call.params);
        await tool.handler(validatedParams);
        if (this.toasts) {
          this.toasts.addSuccess({
            title: `Executed: ${tool.description}`,
            toastLifeTimeMs: 3000
          });
        }
      } catch (error) {
        if (this.toasts) {
          this.toasts.addDanger({
            title: `Failed to execute: ${tool.description}`,
            text: error instanceof Error ? error.message : String(error)
          });
        }
      }
    }
  }
}
exports.BrowserToolExecutor = BrowserToolExecutor;