"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Query keys for react-query
 */
const queryKeys = exports.queryKeys = {
  conversations: {
    all: ['conversations'],
    byAgent: agentId => ['conversations', 'list', {
      agentId
    }],
    byId: conversationId => ['conversations', conversationId]
  },
  agentProfiles: {
    all: ['agentProfiles'],
    byId: agentProfileId => ['agentProfiles', agentProfileId]
  },
  tools: {
    all: ['tools', 'list'],
    typeInfo: ['tools', 'typeInfo'],
    byId: toolId => ['tools', toolId],
    indexSearch: {
      resolveTargets: pattern => ['tools', 'indexSearch', 'resolveTargets', pattern]
    },
    workflows: {
      byId: workflowId => ['tools', 'workflows', workflowId],
      list: () => ['tools', 'workflows', 'list']
    },
    connectors: {
      list: type => ['tools', 'connectors', 'list', type],
      get: connectorId => ['tools', 'connectors', 'get', connectorId],
      listMcpTools: connectorId => ['tools', 'connectors', 'listMcpTools', connectorId]
    },
    health: {
      list: () => ['tools', 'health', 'list'],
      byId: toolId => ['tools', 'health', toolId],
      mcp: () => ['tools', 'health', 'mcp']
    },
    namespace: {
      validate: (namespace, connectorId) => ['tools', 'namespace', 'validate', namespace, connectorId]
    }
  }
};