"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToasts = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToasts = () => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    notifications
  } = services;
  const addSuccessToast = (0, _react.useCallback)(input => {
    notifications.toasts.addSuccess(input);
  }, [notifications.toasts]);
  const addErrorToast = (0, _react.useCallback)(input => {
    notifications.toasts.addDanger(input);
  }, [notifications.toasts]);
  return {
    addSuccessToast,
    addErrorToast
  };
};
exports.useToasts = useToasts;