"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolsHealth = exports.useToolHealth = exports.useMcpToolsHealth = void 0;
var _reactQuery = require("@kbn/react-query");
var _query_keys = require("../../query_keys");
var _use_onechat_service = require("../use_onechat_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_MCP_HEALTH_STATES = [];
const EMPTY_HEALTH_STATES = [];
const useToolsHealth = () => {
  var _data$results;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    ...queryFields
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.health.list(),
    queryFn: () => toolsService.listToolsHealth(),
    retry: false
  });
  return {
    healthStates: (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : EMPTY_HEALTH_STATES,
    ...queryFields
  };
};
exports.useToolsHealth = useToolsHealth;
const useToolHealth = ({
  toolId
}) => {
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    ...queryFields
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.health.byId(toolId),
    queryFn: () => toolsService.getToolHealth({
      toolId
    }),
    enabled: !!toolId,
    retry: false
  });
  return {
    toolHealth: data === null || data === void 0 ? void 0 : data.health,
    ...queryFields
  };
};
exports.useToolHealth = useToolHealth;
const useMcpToolsHealth = ({
  enabled = true
} = {}) => {
  var _data$results2;
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    data,
    ...queryFields
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_keys.queryKeys.tools.health.mcp(),
    queryFn: () => toolsService.listMcpToolsHealth(),
    enabled,
    retry: false
  });
  return {
    mcpHealthStates: (_data$results2 = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results2 !== void 0 ? _data$results2 : EMPTY_MCP_HEALTH_STATES,
    ...queryFields
  };
};
exports.useMcpToolsHealth = useMcpToolsHealth;