"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolResultsFlyout = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToolResultsFlyout = () => {
  const [toolResults, setToolResults] = (0, _react.useState)(null);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const openFlyout = (0, _react.useCallback)(results => {
    setToolResults(results);
    setIsOpen(true);
  }, []);
  const closeFlyout = (0, _react.useCallback)(() => {
    setToolResults(null);
    setIsOpen(false);
  }, []);
  return {
    toolResults,
    isOpen,
    openFlyout,
    closeFlyout
  };
};
exports.useToolResultsFlyout = useToolResultsFlyout;